/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.NamedGroup;
import com.bes.enterprise.cipher.gmssl.TlsECConfigVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECConfig;
import java.util.Vector;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected Vector namedGroups;

    public DefaultTlsECConfigVerifier(int minimumCurveBits, Vector namedGroups) {
        this.minimumCurveBits = Math.max(1, minimumCurveBits);
        this.namedGroups = namedGroups;
    }

    @Override
    public boolean accept(TlsECConfig ecConfig) {
        int namedGroup = ecConfig.getNamedGroup();
        if (namedGroup < 0) {
            return false;
        }
        if (NamedGroup.getCurveBits(namedGroup) < this.minimumCurveBits) {
            return false;
        }
        return this.namedGroups == null || this.namedGroups.contains(namedGroup);
    }
}

