/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.DHPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.DHPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedAgreement;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsDHDomain;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsECDomain;
import java.io.IOException;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new DHCredentialedAgreement(crypto, certificate, (DHPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new ECCredentialedAgreement(crypto, certificate, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(peerCertificate);
    }

    private class ECCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final ECPrivateKeyParameters privateKey;

        ECCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, ECPrivateKeyParameters privateKey) {
            this.crypto = crypto;
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            ECPublicKeyParameters peerPublicKey = BcTlsCertificate.convert(this.crypto, peerCertificate).getPubKeyEC();
            return this.crypto.adoptLocalSecret(BcTlsECDomain.calculateBasicAgreement(this.privateKey, peerPublicKey));
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    private class DHCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final DHPrivateKeyParameters privateKey;

        DHCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, DHPrivateKeyParameters privateKey) {
            this.crypto = crypto;
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            DHPublicKeyParameters peerPublicKey = BcTlsCertificate.convert(this.crypto, peerCertificate).getPubKeyDH();
            return this.crypto.adoptLocalSecret(BcTlsDHDomain.calculateBasicAgreement(this.privateKey, peerPublicKey));
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

