/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.x509.Certificate;
import com.bes.enterprise.cipher.asn1.x509.Extension;
import com.bes.enterprise.cipher.asn1.x509.Extensions;
import com.bes.enterprise.cipher.asn1.x509.KeyUsage;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.DHPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.DSAPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.crypto.util.PublicKeyFactory;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoException;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsDSAVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsECDSAVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsRSAVerifier;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            return Certificate.getInstance(encoding);
        }
        catch (IllegalArgumentException e) {
            throw new TlsCryptoException("unable to decode certificate: " + e.getMessage(), e);
        }
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificate.parseCertificate(encoding));
    }

    public BcTlsCertificate(BcTlsCrypto crypto, Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (publicKey instanceof RSAKeyParameters) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (publicKey instanceof ECPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        DSAPublicKeyParameters pubKeyDSS;
        try {
            pubKeyDSS = (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDSS(pubKeyDSS);
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        ECPublicKeyParameters pubKeyEC;
        try {
            pubKeyEC = (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyEC(pubKeyEC);
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        RSAKeyParameters pubKeyRSA;
        try {
            pubKeyRSA = (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyRSA(pubKeyRSA);
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo keyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = this.certificate.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DSAPublicKeyParameters validatePubKeyDSS(DSAPublicKeyParameters pubKeyDSS) throws IOException {
        return pubKeyDSS;
    }

    protected ECPublicKeyParameters validatePubKeyEC(ECPublicKeyParameters pubKeyEC) throws IOException {
        return pubKeyEC;
    }

    protected RSAKeyParameters validatePubKeyRSA(RSAKeyParameters pubKeyRSA) throws IOException {
        return pubKeyRSA;
    }
}

