/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPair;
import com.bes.enterprise.cipher.crypto.agreement.DHBasicAgreement;
import com.bes.enterprise.cipher.crypto.generators.DHBasicKeyPairGenerator;
import com.bes.enterprise.cipher.crypto.params.DHKeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.params.DHParameters;
import com.bes.enterprise.cipher.crypto.params.DHPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.DHPublicKeyParameters;
import com.bes.enterprise.cipher.gmssl.TlsDHUtils;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.crypto.DHGroup;
import com.bes.enterprise.cipher.gmssl.crypto.TlsAgreement;
import com.bes.enterprise.cipher.gmssl.crypto.TlsDHConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsDHDomain;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsDH;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsSecret;
import com.bes.enterprise.cipher.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhParameters;

    public static byte[] calculateBasicAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        DHBasicAgreement basicAgreement = new DHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(agreementValue);
    }

    public static DHParameters getParameters(TlsDHConfig dhConfig) {
        DHGroup dhGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (dhGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameters(dhGroup.getP(), dhGroup.getG(), dhGroup.getQ(), dhGroup.getL());
    }

    public BcTlsDHDomain(BcTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhParameters = BcTlsDHDomain.getParameters(dhConfig);
    }

    public BcTlsSecret calculateDHAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        return this.crypto.adoptLocalSecret(BcTlsDHDomain.calculateBasicAgreement(privateKey, publicKey));
    }

    @Override
    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] encoding) throws IOException {
        return new BigInteger(1, encoding);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = this.decodeParameter(encoding);
            return new DHPublicKeyParameters(y, this.dhParameters);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(40, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return BigIntegers.asUnsignedByteArray(x);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters publicKey) throws IOException {
        return this.encodeParameter(publicKey.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator keyPairGenerator = new DHBasicKeyPairGenerator();
        keyPairGenerator.init(new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhParameters));
        return keyPairGenerator.generateKeyPair();
    }
}

