/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.crypto.engines.SM2Engine;
import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.DefaultTlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedDecryptor;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaGMSSLSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.ECUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;

public class GMSSLSignerAndDecryptor
extends DefaultTlsCredentialedSigner
implements TlsCredentialedDecryptor {
    protected JcaTlsCrypto crypto;
    protected PrivateKey privateKey;

    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        if (!(privateKey instanceof ECPrivateKey) && !"EC".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        JcaGMSSLSigner signer = new JcaGMSSLSigner(crypto, privateKey);
        return signer;
    }

    public GMSSLSignerAndDecryptor(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, GMSSLSignerAndDecryptor.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!(privateKey instanceof BCECPrivateKey) && !"EC".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, this.privateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, PrivateKey gmServerPrivateKey, byte[] encryptedPreMasterSecret) {
        byte[] m = null;
        try {
            byte[] decryptedData = TlsUtils.parseSm2CipherTextDer(encryptedPreMasterSecret);
            SM2Engine engine = new SM2Engine();
            engine.init(false, ECUtil.generatePrivateKeyParameter(gmServerPrivateKey));
            m = engine.processBlock(decryptedData, 0, decryptedData.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.crypto.createSecret(m);
    }
}

