/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.DefaultTlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsDSASigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsECDSASigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsRSASigner;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        TlsSigner signer;
        if (privateKey instanceof RSAPrivateKey || "RSA".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsRSASigner(crypto, privateKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsDSASigner(crypto, privateKey);
        } else if (privateKey instanceof ECPrivateKey || "EC".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsECDSASigner(crypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

