/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.crypto.engines.SM2Engine;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.gmssl.HashAlgorithm;
import com.bes.enterprise.cipher.gmssl.MACAlgorithm;
import com.bes.enterprise.cipher.gmssl.NamedGroup;
import com.bes.enterprise.cipher.gmssl.ProtocolVersion;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCipher;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoException;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsDHConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsDHDomain;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECDomain;
import com.bes.enterprise.cipher.gmssl.crypto.TlsHMAC;
import com.bes.enterprise.cipher.gmssl.crypto.TlsHash;
import com.bes.enterprise.cipher.gmssl.crypto.TlsNonceGenerator;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.impl.AbstractTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsAEADCipher;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsAEADCipherImpl;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsBlockCipher;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsBlockCipherImpl;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsEncryptor;
import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsNullCipher;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaNonceGenerator;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsHash;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaUtils;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceAEADCipherImpl;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceBlockCipherImpl;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceChaCha20Poly1305;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceTlsDHDomain;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceTlsECDomain;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceTlsHMAC;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JceTlsSecret;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.ECUtil;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.cipher.util.Arrays;
import com.bes.enterprise.cipher.util.Integers;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedGroups = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper helper, SecureRandom entropySource, SecureRandom nonceEntropySource) {
        this.helper = helper;
        this.entropySource = entropySource;
        this.nonceEntropySource = nonceEntropySource;
    }

    JceTlsSecret adoptLocalSecret(byte[] data) {
        return new JceTlsSecret(this, data);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException e) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        return new JcaNonceGenerator(this.nonceEntropySource, additionalSeedMaterial);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public SecretKey calculateKeyAgreement(String agreementAlgorithm, PrivateKey privateKey, PublicKey publicKey, String secretAlgorithm) throws GeneralSecurityException {
        KeyAgreement agreement = this.helper.createKeyAgreement(agreementAlgorithm);
        agreement.init(privateKey);
        agreement.doPhase(publicKey, true);
        return agreement.generateSecret(secretAlgorithm);
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new JcaTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        try {
            switch (encryptionAlgorithm) {
                case 105: {
                    return this.createSM4Cipher(cryptoParams, 16, macAlgorithm);
                }
                case 7: {
                    return this.createDESedeCipher(cryptoParams, macAlgorithm);
                }
                case 8: {
                    return this.createAESCipher(cryptoParams, 16, macAlgorithm);
                }
                case 15: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(cryptoParams, 16, 16);
                }
                case 103: {
                    return this.createCipher_AES_OCB(cryptoParams, 16, 12);
                }
                case 9: {
                    return this.createAESCipher(cryptoParams, 32, macAlgorithm);
                }
                case 17: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(cryptoParams, 32, 16);
                }
                case 104: {
                    return this.createCipher_AES_OCB(cryptoParams, 32, 12);
                }
                case 22: {
                    return this.createARIACipher(cryptoParams, 16, macAlgorithm);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
                }
                case 23: {
                    return this.createARIACipher(cryptoParams, 32, macAlgorithm);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
                }
                case 12: {
                    return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
                }
                case 13: {
                    return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(cryptoParams);
                }
                case 0: {
                    return this.createNullCipher(cryptoParams, macAlgorithm);
                }
                case 14: {
                    return this.createSEEDCipher(cryptoParams, macAlgorithm);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 6: {
                return this.createHMAC("HmacSM3");
            }
            case 1: {
                return this.createHMAC("HmacMD5");
            }
            case 2: {
                return this.createHMAC("HmacSHA1");
            }
            case 3: {
                return this.createHMAC("HmacSHA256");
            }
            case 4: {
                return this.createHMAC("HmacSHA384");
            }
            case 5: {
                return this.createHMAC("HmacSHA512");
            }
        }
        throw new IllegalArgumentException("unknown MACAlgorithm: " + MACAlgorithm.getText(macAlgorithm));
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return !JcaUtils.isSunMSCAPIProviderActive();
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        try {
            switch (encryptionAlgorithm) {
                case 21: {
                    this.helper.createCipher("ChaCha7539");
                    this.helper.createMac("Poly1305");
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.helper.createCipher("AES/CCM/NoPadding");
                    break;
                }
                case 10: 
                case 11: {
                    this.helper.createCipher("AES/GCM/NoPadding");
                    break;
                }
                case 24: 
                case 25: {
                    this.helper.createCipher("ARIA/GCM/NoPadding");
                    break;
                }
                case 19: 
                case 20: {
                    this.helper.createCipher("CAMELLIA/GCM/NoPadding");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNamedGroup(int namedGroup) {
        if (NamedGroup.refersToASpecificFiniteField(namedGroup)) {
            return true;
        }
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return false;
        }
        String curveName = NamedGroup.getName(namedGroup);
        if (curveName == null) {
            return false;
        }
        int key = Integers.valueOf(namedGroup);
        Hashtable hashtable = this.supportedGroups;
        synchronized (hashtable) {
            Boolean cached = (Boolean)this.supportedGroups.get(key);
            if (cached != null) {
                return cached;
            }
        }
        boolean result = this.isCurveSupported(curveName);
        Hashtable hashtable2 = this.supportedGroups;
        synchronized (hashtable2) {
            this.supportedGroups.put(key, result);
        }
        return result;
    }

    @Override
    public boolean hasRSAEncryption() {
        try {
            this.createRSAEncryptionCipher();
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    @Override
    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return sigAndHashAlgorithm.getHash() != 3 || !JcaUtils.isSunMSCAPIProviderActive();
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TlsSecret createSecret(byte[] data) {
        JceTlsSecret jceTlsSecret = this.adoptLocalSecret(Arrays.clone(data));
        return jceTlsSecret;
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    @Override
    public TlsHash createHash(short algorithm) {
        try {
            return this.createHash(this.getDigestName(algorithm));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to create message digest:" + e.getMessage(), e);
        }
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new JceTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new JceTlsECDomain(this, ecConfig);
    }

    @Override
    public TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        JcaTlsCertificate jcaCert = JcaTlsCertificate.convert(this, certificate);
        jcaCert.validateKeyUsage(32);
        final PublicKey pubKey = jcaCert.getPublicKey();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    ECPublicKeyParameters pubKeyParams = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(pubKey);
                    SM2Engine engine = new SM2Engine();
                    ParametersWithRandom pwr = new ParametersWithRandom(pubKeyParams, new SecureRandom());
                    engine.init(true, pwr);
                    byte[] encryptedData = engine.processBlock(input, inOff, length);
                    return TlsUtils.derEncodeSm2CipherText(encryptedData, pubKeyParams);
                }
                catch (Exception e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    protected TlsAEADCipherImpl createAEADCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsHMAC createHMAC(String hmacName) {
        try {
            return new JceTlsHMAC(this.helper.createMac(hmacName), hmacName);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("cannot create HMAC: " + hmacName, e);
        }
    }

    protected TlsHash createHash(String digestName) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(digestName));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(cryptoParams, this.createMAC(macAlgorithm), this.createMAC(macAlgorithm));
    }

    protected boolean isCurveSupported(String curveName) {
        try {
            AlgorithmParameters params = this.getHelper().createAlgorithmParameters("EC");
            params.init(new ECGenParameterSpec(curveName));
            if (params.getParameterSpec(ECParameterSpec.class) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "AES", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "AES", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createSM4Cipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createECBBlockOperator(cryptoParams, "SM4", true, cipherKeySize), this.createECBBlockOperator(cryptoParams, "SM4", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createARIACipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "ARIA", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "ARIA", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "Camellia", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "Camellia", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "DESede", true, 24), this.createCBCBlockOperator(cryptoParams, "DESede", false, 24), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), 24);
    }

    private TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "SEED", true, 16), this.createCBCBlockOperator(cryptoParams, "SEED", false, 16), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), 16);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters cryptoParams, String algorithm, boolean forEncryption, int keySize) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NoPadding";
        return this.createBlockCipherWithCBCImplicitIV(cipherName, algorithm, keySize, forEncryption);
    }

    private TlsBlockCipherImpl createECBBlockOperator(TlsCryptoParameters cryptoParams, String algorithm, boolean forEncryption, int keySize) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NOPadding";
        return this.createBlockCipher(cipherName, algorithm, keySize, forEncryption);
    }

    private TlsHMAC createMAC(int macAlgorithm) throws IOException {
        return this.createHMAC(macAlgorithm);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, new JceChaCha20Poly1305(this.helper, true), new JceChaCha20Poly1305(this.helper, false), 32, 16, 2);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize, 2);
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, false), cipherKeySize, macSize);
    }

    String getDigestName(short hashAlgorithm) {
        String digestName;
        switch (hashAlgorithm) {
            case 7: {
                digestName = "SM3";
                break;
            }
            case 1: {
                digestName = "MD5";
                break;
            }
            case 2: {
                digestName = "SHA-1";
                break;
            }
            case 3: {
                digestName = "SHA-224";
                break;
            }
            case 4: {
                digestName = "SHA-256";
                break;
            }
            case 5: {
                digestName = "SHA-384";
                break;
            }
            case 6: {
                digestName = "SHA-512";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
            }
        }
        return digestName;
    }
}

