/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedAgreement;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoException;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;

public class JceDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    private final JcaTlsCrypto crypto;
    private final Certificate certificate;
    private final PrivateKey privateKey;
    private final String agreementAlgorithm;

    public static String getAgreementAlgorithm(PrivateKey privateKey) {
        if (privateKey instanceof DHPrivateKey) {
            return "DH";
        }
        if (privateKey instanceof ECPrivateKey) {
            return "ECDH";
        }
        throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
    }

    public JceDefaultTlsCredentialedAgreement(JcaTlsCrypto crypto, Certificate certificate, PrivateKey privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.agreementAlgorithm = JceDefaultTlsCredentialedAgreement.getAgreementAlgorithm(privateKey);
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        try {
            PublicKey publicKey = JcaTlsCertificate.convert(this.crypto, peerCertificate).getPublicKey();
            SecretKey secretKey = this.crypto.calculateKeyAgreement(this.agreementAlgorithm, this.privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(secretKey.getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to perform agreement", e);
        }
    }
}

