/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.asymmetric;

import com.bes.enterprise.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x9.X9ObjectIdentifiers;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyFactorySpi;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.util.AsymmetricAlgorithmProvider;
import java.util.HashMap;
import java.util.Map;

public class DH {
    private static final String PREFIX = "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.";
    private static final Map<String, String> generalDhAttributes = new HashMap<String, String>();

    static {
        generalDhAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        generalDhAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("KeyPairGenerator.DH", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyPairGeneratorSpi");
            provider.addAlgorithm("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
            provider.addAttributes("KeyAgreement.DH", generalDhAttributes);
            provider.addAlgorithm("KeyAgreement.DH", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi");
            provider.addAlgorithm("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("KeyAgreement", PKCSObjectIdentifiers.id_alg_ESDH, "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithRFC2631KDF");
            provider.addAlgorithm("KeyAgreement", PKCSObjectIdentifiers.id_alg_SSDH, "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithRFC2631KDF");
            provider.addAlgorithm("KeyFactory.DH", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyFactorySpi");
            provider.addAlgorithm("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("AlgorithmParameters.DH", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.AlgorithmParametersSpi");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
            provider.addAlgorithm("AlgorithmParameterGenerator.DH", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.AlgorithmParameterGeneratorSpi");
            provider.addAlgorithm("Cipher.IES", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IES");
            provider.addAlgorithm("Cipher.IESwithAES-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.IESWITHAES-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.IESWITHDESEDE-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithDESedeCBC");
            provider.addAlgorithm("Cipher.DHIES", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IES");
            provider.addAlgorithm("Cipher.DHIESwithAES-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.DHIESWITHAES-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithAESCBC");
            provider.addAlgorithm("Cipher.DHIESWITHDESEDE-CBC", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.IESCipher$IESwithDESedeCBC");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA1KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA224KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA256KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA384KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.DHWITHSHA512KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA1KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA224KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA256KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA384KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA512KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA1CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA1CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA224CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA224CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA256CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA256CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA384CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA384CKDF");
            provider.addAlgorithm("KeyAgreement.DHUWITHSHA512CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHUwithSHA512CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA1KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA224KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA224KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA256KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA256KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA384KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA384KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA512KDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA512KDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA1CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA1CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA224CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA224CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA256CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA256CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA384CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA384CKDF");
            provider.addAlgorithm("KeyAgreement.MQVWITHSHA512CKDF", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQVwithSHA512CKDF");
            this.registerOid(provider, PKCSObjectIdentifiers.dhKeyAgreement, "DH", new KeyFactorySpi());
            this.registerOid(provider, X9ObjectIdentifiers.dhpublicnumber, "DH", new KeyFactorySpi());
        }
    }
}

