/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.asymmetric;

import com.bes.enterprise.cipher.asn1.nist.NISTObjectIdentifiers;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.KeyFactorySpi;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.util.AsymmetricAlgorithmProvider;

public class DSA {
    private static final String PREFIX = "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.";

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.AlgorithmParametersSpi");
            provider.addAlgorithm("AlgorithmParameterGenerator.DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.AlgorithmParameterGeneratorSpi");
            provider.addAlgorithm("KeyPairGenerator.DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.KeyPairGeneratorSpi");
            provider.addAlgorithm("KeyFactory.DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.KeyFactorySpi");
            provider.addAlgorithm("Signature.DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$stdDSA");
            provider.addAlgorithm("Signature.NONEWITHDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$noneDSA");
            provider.addAlgorithm("Alg.Alias.Signature.RAWDSA", "NONEWITHDSA");
            provider.addAlgorithm("Signature.DETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA1WITHDETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA224WITHDETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA224");
            provider.addAlgorithm("Signature.SHA256WITHDETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA256");
            provider.addAlgorithm("Signature.SHA384WITHDETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA384");
            provider.addAlgorithm("Signature.SHA512WITHDETDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA512");
            provider.addAlgorithm("Signature.DDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA1WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA224WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA224");
            provider.addAlgorithm("Signature.SHA256WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA256");
            provider.addAlgorithm("Signature.SHA384WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA384");
            provider.addAlgorithm("Signature.SHA512WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSA512");
            provider.addAlgorithm("Signature.SHA3-224WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_224");
            provider.addAlgorithm("Signature.SHA3-256WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_256");
            provider.addAlgorithm("Signature.SHA3-384WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_384");
            provider.addAlgorithm("Signature.SHA3-512WITHDDSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_512");
            this.addSignatureAlgorithm(provider, "SHA224", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsa224", NISTObjectIdentifiers.dsa_with_sha224);
            this.addSignatureAlgorithm(provider, "SHA256", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256);
            this.addSignatureAlgorithm(provider, "SHA384", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsa384", NISTObjectIdentifiers.dsa_with_sha384);
            this.addSignatureAlgorithm(provider, "SHA512", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsa512", NISTObjectIdentifiers.dsa_with_sha512);
            this.addSignatureAlgorithm(provider, "SHA3-224", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_224", NISTObjectIdentifiers.id_dsa_with_sha3_224);
            this.addSignatureAlgorithm(provider, "SHA3-256", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_256", NISTObjectIdentifiers.id_dsa_with_sha3_256);
            this.addSignatureAlgorithm(provider, "SHA3-384", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_384", NISTObjectIdentifiers.id_dsa_with_sha3_384);
            this.addSignatureAlgorithm(provider, "SHA3-512", "DSA", "com.bes.enterprise.cipher.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_512", NISTObjectIdentifiers.id_dsa_with_sha3_512);
            provider.addAlgorithm("Alg.Alias.Signature.SHA/DSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1withDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WITHDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.3", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAwithSHA1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAWITHSHA1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WithDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAWithSHA1", "DSA");
            KeyFactorySpi keyFact = new KeyFactorySpi();
            for (int i = 0; i != DSAUtil.dsaOids.length; ++i) {
                provider.addAlgorithm("Alg.Alias.Signature." + DSAUtil.dsaOids[i], "DSA");
                this.registerOid(provider, DSAUtil.dsaOids[i], "DSA", keyFact);
                this.registerOidAlgorithmParameterGenerator(provider, DSAUtil.dsaOids[i], "DSA");
            }
        }
    }
}

