/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.asymmetric.ec;

import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.ASN1Integer;
import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.crypto.DSA;
import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.digests.NullDigest;
import com.bes.enterprise.cipher.crypto.digests.RIPEMD160Digest;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.crypto.signers.ECDSASigner;
import com.bes.enterprise.cipher.crypto.signers.ECNRSigner;
import com.bes.enterprise.cipher.crypto.signers.HMacDSAKCalculator;
import com.bes.enterprise.cipher.crypto.util.DigestFactory;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.ec.ECUtils;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.DSABase;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.DSAEncoder;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.ECUtil;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SignatureSpi
extends DSABase {
    SignatureSpi(Digest digest, DSA signer, DSAEncoder encoder) {
        super(digest, signer, encoder);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtils.generatePublicKeyParameter(publicKey);
        this.digest.reset();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (this.appRandom != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.appRandom));
        } else {
            this.signer.init(true, param);
        }
    }

    private static class PlainDSAEncoder
    implements DSAEncoder {
        private PlainDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            byte[] second;
            byte[] first = this.makeUnsigned(r);
            byte[] res = first.length > (second = this.makeUnsigned(s)).length ? new byte[first.length * 2] : new byte[second.length * 2];
            System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
            System.arraycopy(second, 0, res, res.length - second.length, second.length);
            return res;
        }

        private byte[] makeUnsigned(BigInteger val) {
            byte[] res = val.toByteArray();
            if (res[0] == 0) {
                byte[] tmp = new byte[res.length - 1];
                System.arraycopy(res, 1, tmp, 0, tmp.length);
                return tmp;
            }
            return res;
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            byte[] first = new byte[encoding.length / 2];
            byte[] second = new byte[encoding.length / 2];
            System.arraycopy(encoding, 0, first, 0, first.length);
            System.arraycopy(encoding, first.length, second, 0, second.length);
            sig[0] = new BigInteger(1, first);
            sig[1] = new BigInteger(1, second);
            return sig;
        }
    }

    private static class StdDSAEncoder
    implements DSAEncoder {
        private StdDSAEncoder() {
        }

        @Override
        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(r));
            v.add(new ASN1Integer(s));
            return new DERSequence(v).getEncoded("DER");
        }

        @Override
        public BigInteger[] decode(byte[] encoding) throws IOException {
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            if (s.size() != 2) {
                throw new IOException("malformed signature");
            }
            if (!Arrays.areEqual(encoding, s.getEncoded("DER"))) {
                throw new IOException("malformed signature");
            }
            BigInteger[] sig = new BigInteger[]{ASN1Integer.getInstance(s.getObjectAt(0)).getValue(), ASN1Integer.getInstance(s.getObjectAt(1)).getValue()};
            return sig;
        }
    }

    public static class ecPlainDSARP160
    extends SignatureSpi {
        public ecPlainDSARP160() {
            super(new RIPEMD160Digest(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecCVCDSA512
    extends SignatureSpi {
        public ecCVCDSA512() {
            super(DigestFactory.createSHA512(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecCVCDSA384
    extends SignatureSpi {
        public ecCVCDSA384() {
            super(DigestFactory.createSHA384(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecCVCDSA256
    extends SignatureSpi {
        public ecCVCDSA256() {
            super(DigestFactory.createSHA256(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecCVCDSA224
    extends SignatureSpi {
        public ecCVCDSA224() {
            super(DigestFactory.createSHA224(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecCVCDSA
    extends SignatureSpi {
        public ecCVCDSA() {
            super(DigestFactory.createSHA1(), new ECDSASigner(), new PlainDSAEncoder());
        }
    }

    public static class ecNR512
    extends SignatureSpi {
        public ecNR512() {
            super(DigestFactory.createSHA512(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR384
    extends SignatureSpi {
        public ecNR384() {
            super(DigestFactory.createSHA384(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR256
    extends SignatureSpi {
        public ecNR256() {
            super(DigestFactory.createSHA256(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR224
    extends SignatureSpi {
        public ecNR224() {
            super(DigestFactory.createSHA224(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR
    extends SignatureSpi {
        public ecNR() {
            super(DigestFactory.createSHA1(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSARipeMD160
    extends SignatureSpi {
        public ecDSARipeMD160() {
            super(new RIPEMD160Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSASha3_512
    extends SignatureSpi {
        public ecDetDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_512())), new StdDSAEncoder());
        }
    }

    public static class ecDSASha3_512
    extends SignatureSpi {
        public ecDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSASha3_384
    extends SignatureSpi {
        public ecDetDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_384())), new StdDSAEncoder());
        }
    }

    public static class ecDSASha3_384
    extends SignatureSpi {
        public ecDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSASha3_256
    extends SignatureSpi {
        public ecDetDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_256())), new StdDSAEncoder());
        }
    }

    public static class ecDSASha3_256
    extends SignatureSpi {
        public ecDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSASha3_224
    extends SignatureSpi {
        public ecDetDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_224())), new StdDSAEncoder());
        }
    }

    public static class ecDSASha3_224
    extends SignatureSpi {
        public ecDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA512
    extends SignatureSpi {
        public ecDetDSA512() {
            super(DigestFactory.createSHA512(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA512())), new StdDSAEncoder());
        }
    }

    public static class ecDSA512
    extends SignatureSpi {
        public ecDSA512() {
            super(DigestFactory.createSHA512(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA384
    extends SignatureSpi {
        public ecDetDSA384() {
            super(DigestFactory.createSHA384(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA384())), new StdDSAEncoder());
        }
    }

    public static class ecDSA384
    extends SignatureSpi {
        public ecDSA384() {
            super(DigestFactory.createSHA384(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA256
    extends SignatureSpi {
        public ecDetDSA256() {
            super(DigestFactory.createSHA256(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA256())), new StdDSAEncoder());
        }
    }

    public static class ecDSA256
    extends SignatureSpi {
        public ecDSA256() {
            super(DigestFactory.createSHA256(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA224
    extends SignatureSpi {
        public ecDetDSA224() {
            super(DigestFactory.createSHA224(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA224())), new StdDSAEncoder());
        }
    }

    public static class ecDSA224
    extends SignatureSpi {
        public ecDSA224() {
            super(DigestFactory.createSHA224(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSAnone
    extends SignatureSpi {
        public ecDSAnone() {
            super(new NullDigest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA
    extends SignatureSpi {
        public ecDetDSA() {
            super(DigestFactory.createSHA1(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA1())), new StdDSAEncoder());
        }
    }

    public static class ecDSA
    extends SignatureSpi {
        public ecDSA() {
            super(DigestFactory.createSHA1(), new ECDSASigner(), new StdDSAEncoder());
        }
    }
}

