/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.digest;

import com.bes.enterprise.cipher.crypto.digests.SM3Digest;
import com.bes.enterprise.cipher.crypto.macs.HMac;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.digest.BCMessageDigest;
import com.bes.enterprise.cipher.jcajce.provider.digest.DigestAlgorithmProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseMac;

public class SM3 {
    private SM3() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SM3.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SM3", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SM3", "SM3");
            provider.addAlgorithm("Alg.Alias.MessageDigest.1.2.156.197.1.401", "SM3");
            provider.addAlgorithm("Mac.HmacSM3", PREFIX + "$HashMac");
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SM3Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SM3Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SM3Digest((SM3Digest)this.digest);
            return d;
        }
    }
}

