/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.openssl;

import com.bes.enterprise.cipher.openssl.PEMDecryptor;
import com.bes.enterprise.cipher.openssl.PEMDecryptorProvider;
import com.bes.enterprise.cipher.openssl.PEMException;
import com.bes.enterprise.cipher.openssl.PEMKeyPair;
import com.bes.enterprise.cipher.openssl.PEMKeyPairParser;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import java.io.IOException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor keyDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(keyDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException e) {
            throw e;
        }
        catch (OperatorCreationException e) {
            throw new PEMException("cannot create extraction operator: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PEMException("exception processing key pair: " + e.getMessage(), e);
        }
    }
}

