/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.openssl;

import com.bes.enterprise.cipher.asn1.ASN1InputStream;
import com.bes.enterprise.cipher.asn1.ASN1Integer;
import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.DERNull;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.pkcs.RSAPrivateKey;
import com.bes.enterprise.cipher.asn1.pkcs.RSAPublicKey;
import com.bes.enterprise.cipher.asn1.sec.ECPrivateKey;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.DSAParameter;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.asn1.x9.X9ECParameters;
import com.bes.enterprise.cipher.asn1.x9.X9ObjectIdentifiers;
import com.bes.enterprise.cipher.cert.X509AttributeCertificateHolder;
import com.bes.enterprise.cipher.cert.X509CRLHolder;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.openssl.PEMEncryptedKeyPair;
import com.bes.enterprise.cipher.openssl.PEMException;
import com.bes.enterprise.cipher.openssl.PEMKeyPair;
import com.bes.enterprise.cipher.openssl.PEMKeyPairParser;
import com.bes.enterprise.cipher.openssl.X509TrustedCertificateBlock;
import com.bes.enterprise.cipher.pkcs.PKCS10CertificationRequest;
import com.bes.enterprise.cipher.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.bes.enterprise.cipher.util.encoders.Hex;
import com.bes.enterprise.cipher.util.io.pem.PemHeader;
import com.bes.enterprise.cipher.util.io.pem.PemObject;
import com.bes.enterprise.cipher.util.io.pem.PemObjectParser;
import com.bes.enterprise.cipher.util.io.pem.PemReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PEMParser
extends PemReader {
    private final Map parsers = new HashMap();

    public PEMParser(Reader reader) {
        super(reader);
        this.parsers.put("CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("NEW CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("CERTIFICATE", new X509CertificateParser());
        this.parsers.put("TRUSTED CERTIFICATE", new X509TrustedCertificateParser());
        this.parsers.put("X509 CERTIFICATE", new X509CertificateParser());
        this.parsers.put("X509 CRL", new X509CRLParser());
        this.parsers.put("PKCS7", new PKCS7Parser());
        this.parsers.put("CMS", new PKCS7Parser());
        this.parsers.put("ATTRIBUTE CERTIFICATE", new X509AttributeCertificateParser());
        this.parsers.put("EC PARAMETERS", new ECCurveParamsParser());
        this.parsers.put("PUBLIC KEY", new PublicKeyParser());
        this.parsers.put("RSA PUBLIC KEY", new RSAPublicKeyParser());
        this.parsers.put("RSA PRIVATE KEY", new KeyPairParser(new RSAKeyPairParser()));
        this.parsers.put("DSA PRIVATE KEY", new KeyPairParser(new DSAKeyPairParser()));
        this.parsers.put("EC PRIVATE KEY", new KeyPairParser(new ECDSAKeyPairParser()));
        this.parsers.put("ENCRYPTED PRIVATE KEY", new EncryptedPrivateKeyParser());
        this.parsers.put("PRIVATE KEY", new PrivateKeyParser());
    }

    public Object readObject() throws IOException {
        PemObject obj = this.readPemObject();
        if (obj != null) {
            String type = obj.getType();
            if (this.parsers.containsKey(type)) {
                return ((PemObjectParser)this.parsers.get(type)).parseObject(obj);
            }
            throw new IOException("unrecognised object: " + type);
        }
        return null;
    }

    private class PrivateKeyParser
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return PrivateKeyInfo.getInstance(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing PRIVATE KEY: " + e.toString(), e);
            }
        }
    }

    private class EncryptedPrivateKeyParser
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(obj.getContent()));
            }
            catch (Exception e) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + e.toString(), e);
            }
        }
    }

    private class ECCurveParamsParser
    implements PemObjectParser {
        private ECCurveParamsParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1Primitive param = ASN1Primitive.fromByteArray(obj.getContent());
                if (param instanceof ASN1ObjectIdentifier) {
                    return ASN1Primitive.fromByteArray(obj.getContent());
                }
                if (param instanceof ASN1Sequence) {
                    return X9ECParameters.getInstance(param);
                }
                return null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("exception extracting EC named curve: " + e.toString());
            }
        }
    }

    private class X509AttributeCertificateParser
    implements PemObjectParser {
        private X509AttributeCertificateParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            return new X509AttributeCertificateHolder(obj.getContent());
        }
    }

    private class PKCS7Parser
    implements PemObjectParser {
        private PKCS7Parser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1InputStream aIn = new ASN1InputStream(obj.getContent());
                return ContentInfo.getInstance(aIn.readObject());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing PKCS7 object: " + e.toString(), e);
            }
        }
    }

    private class PKCS10CertificationRequestParser
    implements PemObjectParser {
        private PKCS10CertificationRequestParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS10CertificationRequest(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing certrequest: " + e.toString(), e);
            }
        }
    }

    private class X509CRLParser
    implements PemObjectParser {
        private X509CRLParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CRLHolder(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private class X509TrustedCertificateParser
    implements PemObjectParser {
        private X509TrustedCertificateParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509TrustedCertificateBlock(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private class X509CertificateParser
    implements PemObjectParser {
        private X509CertificateParser() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CertificateHolder(obj.getContent());
            }
            catch (Exception e) {
                throw new PEMException("problem parsing cert: " + e.toString(), e);
            }
        }
    }

    private class RSAPublicKeyParser
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                RSAPublicKey rsaPubStructure = RSAPublicKey.getInstance(obj.getContent());
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), rsaPubStructure);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem extracting key: " + e.toString(), e);
            }
        }
    }

    private class PublicKeyParser
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            return SubjectPublicKeyInfo.getInstance(obj.getContent());
        }
    }

    private class RSAKeyPairParser
    implements PEMKeyPairParser {
        private RSAKeyPairParser() {
        }

        @Override
        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey keyStruct = RSAPrivateKey.getInstance(seq);
                RSAPublicKey pubSpec = new RSAPublicKey(keyStruct.getModulus(), keyStruct.getPublicExponent());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
                return new PEMKeyPair(new SubjectPublicKeyInfo(algId, pubSpec), new PrivateKeyInfo(algId, keyStruct));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating RSA private key: " + e.toString(), e);
            }
        }
    }

    private class ECDSAKeyPairParser
    implements PEMKeyPairParser {
        private ECDSAKeyPairParser() {
        }

        @Override
        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                ECPrivateKey pKey = ECPrivateKey.getInstance(seq);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, pKey.getParameters());
                PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey);
                if (pKey.getPublicKey() != null) {
                    SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
                    return new PEMKeyPair(pubInfo, privInfo);
                }
                return new PEMKeyPair(null, privInfo);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating EC private key: " + e.toString(), e);
            }
        }
    }

    private class DSAKeyPairParser
    implements PEMKeyPairParser {
        private DSAKeyPairParser() {
        }

        @Override
        public PEMKeyPair parse(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                ASN1Integer p = ASN1Integer.getInstance(seq.getObjectAt(1));
                ASN1Integer q = ASN1Integer.getInstance(seq.getObjectAt(2));
                ASN1Integer g = ASN1Integer.getInstance(seq.getObjectAt(3));
                ASN1Integer y = ASN1Integer.getInstance(seq.getObjectAt(4));
                ASN1Integer x = ASN1Integer.getInstance(seq.getObjectAt(5));
                return new PEMKeyPair(new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(p.getValue(), q.getValue(), g.getValue())), y), new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(p.getValue(), q.getValue(), g.getValue())), x));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PEMException("problem creating DSA private key: " + e.toString(), e);
            }
        }
    }

    private class KeyPairParser
    implements PemObjectParser {
        private final PEMKeyPairParser pemKeyPairParser;

        public KeyPairParser(PEMKeyPairParser pemKeyPairParser) {
            this.pemKeyPairParser = pemKeyPairParser;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            boolean isEncrypted = false;
            String dekInfo = null;
            List headers = obj.getHeaders();
            for (PemHeader hdr : headers) {
                if (hdr.getName().equals("Proc-Type") && hdr.getValue().equals("4,ENCRYPTED")) {
                    isEncrypted = true;
                    continue;
                }
                if (!hdr.getName().equals("DEK-Info")) continue;
                dekInfo = hdr.getValue();
            }
            byte[] keyBytes = obj.getContent();
            try {
                if (isEncrypted) {
                    StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
                    String dekAlgName = tknz.nextToken();
                    byte[] iv = Hex.decode(tknz.nextToken());
                    return new PEMEncryptedKeyPair(dekAlgName, iv, keyBytes, this.pemKeyPairParser);
                }
                return this.pemKeyPairParser.parse(keyBytes);
            }
            catch (IOException e) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e);
                }
                throw new PEMException(e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e);
                }
                throw new PEMException(e.getMessage(), e);
            }
        }
    }
}

