/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.openssl.bc;

import com.bes.enterprise.cipher.openssl.PEMDecryptor;
import com.bes.enterprise.cipher.openssl.PEMDecryptorProvider;
import com.bes.enterprise.cipher.openssl.PEMException;
import com.bes.enterprise.cipher.openssl.PasswordException;
import com.bes.enterprise.cipher.openssl.bc.PEMUtilities;

public class BcPEMDecryptorProvider
implements PEMDecryptorProvider {
    private final char[] password;

    public BcPEMDecryptorProvider(char[] password) {
        this.password = password;
    }

    @Override
    public PEMDecryptor get(final String dekAlgName) {
        return new PEMDecryptor(){

            @Override
            public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                if (BcPEMDecryptorProvider.this.password == null) {
                    throw new PasswordException("Password is null, but a password is required");
                }
                return PEMUtilities.crypt(false, keyBytes, BcPEMDecryptorProvider.this.password, dekAlgName, iv);
            }
        };
    }
}

