/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.openssl.jcajce;

import com.bes.enterprise.cipher.asn1.pkcs.EncryptionScheme;
import com.bes.enterprise.cipher.asn1.pkcs.KeyDerivationFunc;
import com.bes.enterprise.cipher.asn1.pkcs.PBEParameter;
import com.bes.enterprise.cipher.asn1.pkcs.PBES2Parameters;
import com.bes.enterprise.cipher.asn1.pkcs.PBKDF2Params;
import com.bes.enterprise.cipher.asn1.pkcs.PKCS12PBEParams;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.CharToByteConverter;
import com.bes.enterprise.cipher.jcajce.PBKDF1KeyWithParameters;
import com.bes.enterprise.cipher.jcajce.PKCS12KeyWithParameters;
import com.bes.enterprise.cipher.jcajce.util.DefaultJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.NamedJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.ProviderJcaJceHelper;
import com.bes.enterprise.cipher.openssl.PEMException;
import com.bes.enterprise.cipher.openssl.jcajce.PEMUtilities;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import com.bes.enterprise.cipher.operator.InputDecryptorProvider;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = PEMUtilities.isHmacSHA1(defParams.getPrf()) ? PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount) : PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount, defParams.getPrf());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(oid);
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (PEMUtilities.isPKCS12(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, new PKCS12KeyWithParameters(password, params.getIV(), params.getIterations().intValue()));
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, new PBKDF1KeyWithParameters(password, new CharToByteConverter(){

                            @Override
                            public String getType() {
                                return "ASCII";
                            }

                            @Override
                            public byte[] convert(char[] password) {
                                return Strings.toByteArray(password);
                            }
                        }, params.getSalt(), params.getIterationCount().intValue()));
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithm;
                        }

                        @Override
                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, cipher);
                        }
                    };
                }
                catch (IOException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
            }
        };
    }
}

