/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.openssl.jcajce;

import com.bes.enterprise.cipher.jcajce.util.DefaultJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.NamedJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.ProviderJcaJceHelper;
import com.bes.enterprise.cipher.openssl.PEMEncryptor;
import com.bes.enterprise.cipher.openssl.PEMException;
import com.bes.enterprise.cipher.openssl.jcajce.PEMUtilities;
import java.security.Provider;
import java.security.SecureRandom;

public class JcePEMEncryptorBuilder {
    private final String algorithm;
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private SecureRandom random;

    public JcePEMEncryptorBuilder(String algorithm) {
        this.algorithm = algorithm;
    }

    public JcePEMEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMEncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePEMEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PEMEncryptor build(final char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        int ivLength = this.algorithm.startsWith("AES-") ? 16 : 8;
        final byte[] iv = new byte[ivLength];
        this.random.nextBytes(iv);
        return new PEMEncryptor(){

            @Override
            public String getAlgorithm() {
                return JcePEMEncryptorBuilder.this.algorithm;
            }

            @Override
            public byte[] getIV() {
                return iv;
            }

            @Override
            public byte[] encrypt(byte[] encoding) throws PEMException {
                return PEMUtilities.crypt(true, JcePEMEncryptorBuilder.this.helper, encoding, password, JcePEMEncryptorBuilder.this.algorithm, iv);
            }
        };
    }
}

