/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.operator.bc;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.AsymmetricBlockCipher;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.InvalidCipherTextException;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.operator.AsymmetricKeyWrapper;
import com.bes.enterprise.cipher.operator.GenericKey;
import com.bes.enterprise.cipher.operator.OperatorException;
import com.bes.enterprise.cipher.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter publicKey) {
        super(encAlgId);
        this.publicKey = publicKey;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        AsymmetricBlockCipher keyEncryptionCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters params = this.publicKey;
        if (this.random != null) {
            params = new ParametersWithRandom(params, this.random);
        }
        try {
            byte[] keyEnc = OperatorUtils.getKeyBytes(encryptionKey);
            keyEncryptionCipher.init(true, params);
            return keyEncryptionCipher.processBlock(keyEnc, 0, keyEnc.length);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to encrypt contents key", e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

