/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.operator.bc;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.CryptoException;
import com.bes.enterprise.cipher.crypto.Signer;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.operator.ContentSigner;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.operator.RuntimeOperatorException;
import com.bes.enterprise.cipher.operator.bc.BcDefaultDigestProvider;
import com.bes.enterprise.cipher.operator.bc.BcDigestProvider;
import com.bes.enterprise.cipher.operator.bc.BcSignerOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter privateKey) throws OperatorCreationException {
        final Signer sig = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            sig.init(true, new ParametersWithRandom(privateKey, this.random));
        } else {
            sig.init(true, privateKey);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(sig);
            }

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.stream;
            }

            @Override
            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

