/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.operator.bc;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.nist.NISTObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.ExtendedDigest;
import com.bes.enterprise.cipher.crypto.digests.GOST3411Digest;
import com.bes.enterprise.cipher.crypto.digests.GOST3411_2012_256Digest;
import com.bes.enterprise.cipher.crypto.digests.GOST3411_2012_512Digest;
import com.bes.enterprise.cipher.crypto.digests.MD2Digest;
import com.bes.enterprise.cipher.crypto.digests.MD4Digest;
import com.bes.enterprise.cipher.crypto.digests.MD5Digest;
import com.bes.enterprise.cipher.crypto.digests.RIPEMD128Digest;
import com.bes.enterprise.cipher.crypto.digests.RIPEMD160Digest;
import com.bes.enterprise.cipher.crypto.digests.RIPEMD256Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA1Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA224Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA256Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA384Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA3Digest;
import com.bes.enterprise.cipher.crypto.digests.SHA512Digest;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.operator.bc.BcDigestProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BcDefaultDigestProvider
implements BcDigestProvider {
    private static final Map lookup = BcDefaultDigestProvider.createTable();
    public static final BcDigestProvider INSTANCE = new BcDefaultDigestProvider();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, BcDigestProvider> table = new HashMap<ASN1ObjectIdentifier, BcDigestProvider>();
        table.put(OIWObjectIdentifiers.idSHA1, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA1Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha224, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA224Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha256, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA256Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha384, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA384Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha512, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA512Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha3_224, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA3Digest(224);
            }
        });
        table.put(NISTObjectIdentifiers.id_sha3_256, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA3Digest(256);
            }
        });
        table.put(NISTObjectIdentifiers.id_sha3_384, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA3Digest(384);
            }
        });
        table.put(NISTObjectIdentifiers.id_sha3_512, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA3Digest(512);
            }
        });
        table.put(PKCSObjectIdentifiers.md5, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD5Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.md4, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD4Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.md2, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD2Digest();
            }
        });
        table.put(CryptoProObjectIdentifiers.gostR3411, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new GOST3411Digest();
            }
        });
        table.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new GOST3411_2012_256Digest();
            }
        });
        table.put(RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new GOST3411_2012_512Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd128, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD128Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd160, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD160Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd256, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD256Digest();
            }
        });
        return Collections.unmodifiableMap(table);
    }

    private BcDefaultDigestProvider() {
    }

    @Override
    public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        BcDigestProvider extProv = (BcDigestProvider)lookup.get(digestAlgorithmIdentifier.getAlgorithm());
        if (extProv == null) {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return extProv.get(digestAlgorithmIdentifier);
    }
}

