/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs;

import com.bes.enterprise.cipher.asn1.pkcs.MacData;
import com.bes.enterprise.cipher.asn1.pkcs.PKCS12PBEParams;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.DigestInfo;
import com.bes.enterprise.cipher.operator.MacCalculator;
import com.bes.enterprise.cipher.pkcs.PKCS12MacCalculatorBuilder;
import com.bes.enterprise.cipher.pkcs.PKCSException;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder builder) {
        this.builder = builder;
    }

    public MacData build(char[] password, byte[] data) throws PKCSException {
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(password);
            OutputStream out = macCalculator.getOutputStream();
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            throw new PKCSException("unable to process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier algId = macCalculator.getAlgorithmIdentifier();
        DigestInfo dInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
        return new MacData(dInfo, params.getIV(), params.getIterations().intValue());
    }
}

