/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.ASN1Set;
import com.bes.enterprise.cipher.asn1.pkcs.Attribute;
import com.bes.enterprise.cipher.asn1.pkcs.CRLBag;
import com.bes.enterprise.cipher.asn1.pkcs.CertBag;
import com.bes.enterprise.cipher.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.pkcs.SafeBag;
import com.bes.enterprise.cipher.asn1.x509.Certificate;
import com.bes.enterprise.cipher.asn1.x509.CertificateList;
import com.bes.enterprise.cipher.cert.X509CRLHolder;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PKCS12SafeBag {
    public static final ASN1ObjectIdentifier friendlyNameAttribute = PKCSObjectIdentifiers.pkcs_9_at_friendlyName;
    public static final ASN1ObjectIdentifier localKeyIdAttribute = PKCSObjectIdentifiers.pkcs_9_at_localKeyId;
    private SafeBag safeBag;

    public PKCS12SafeBag(SafeBag safeBag) {
        this.safeBag = safeBag;
    }

    public SafeBag toASN1Structure() {
        return this.safeBag;
    }

    public ASN1ObjectIdentifier getType() {
        return this.safeBag.getBagId();
    }

    public Attribute[] getAttributes() {
        ASN1Set attrs = this.safeBag.getBagAttributes();
        if (attrs == null) {
            return null;
        }
        Attribute[] attributes = new Attribute[attrs.size()];
        for (int i = 0; i != attrs.size(); ++i) {
            attributes[i] = Attribute.getInstance(attrs.getObjectAt(i));
        }
        return attributes;
    }

    public Object getBagValue() {
        if (this.getType().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
            return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(this.safeBag.getBagValue()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.certBag)) {
            CertBag certBag = CertBag.getInstance(this.safeBag.getBagValue());
            return new X509CertificateHolder(Certificate.getInstance(ASN1OctetString.getInstance(certBag.getCertValue()).getOctets()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.keyBag)) {
            return PrivateKeyInfo.getInstance(this.safeBag.getBagValue());
        }
        if (this.getType().equals(PKCSObjectIdentifiers.crlBag)) {
            CRLBag crlBag = CRLBag.getInstance(this.safeBag.getBagValue());
            return new X509CRLHolder(CertificateList.getInstance(ASN1OctetString.getInstance(crlBag.getCrlValue()).getOctets()));
        }
        return this.safeBag.getBagValue();
    }
}

