/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs;

import com.bes.enterprise.cipher.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.operator.OutputEncryptor;
import com.bes.enterprise.cipher.pkcs.PKCS8EncryptedPrivateKeyInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PKCS8EncryptedPrivateKeyInfoBuilder {
    private PrivateKeyInfo privateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfoBuilder(byte[] privateKeyInfo) {
        this(PrivateKeyInfo.getInstance(privateKeyInfo));
    }

    public PKCS8EncryptedPrivateKeyInfoBuilder(PrivateKeyInfo privateKeyInfo) {
        this.privateKeyInfo = privateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo build(OutputEncryptor encryptor) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream cOut = encryptor.getOutputStream(bOut);
            cOut.write(this.privateKeyInfo.getEncoded());
            cOut.close();
            return new PKCS8EncryptedPrivateKeyInfo(new EncryptedPrivateKeyInfo(encryptor.getAlgorithmIdentifier(), bOut.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot encode privateKeyInfo");
        }
    }
}

