/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs.bc;

import com.bes.enterprise.cipher.asn1.DERNull;
import com.bes.enterprise.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.pkcs.PKCS12PBEParams;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.ExtendedDigest;
import com.bes.enterprise.cipher.crypto.digests.SHA1Digest;
import com.bes.enterprise.cipher.operator.MacCalculator;
import com.bes.enterprise.cipher.pkcs.PKCS12MacCalculatorBuilder;
import com.bes.enterprise.cipher.pkcs.bc.PKCS12PBEUtils;
import java.security.SecureRandom;

public class BcPKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private ExtendedDigest digest;
    private AlgorithmIdentifier algorithmIdentifier;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public BcPKCS12MacCalculatorBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE));
    }

    public BcPKCS12MacCalculatorBuilder(ExtendedDigest digest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = digest;
        this.algorithmIdentifier = algorithmIdentifier;
        this.saltLength = digest.getDigestSize();
    }

    public BcPKCS12MacCalculatorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public MacCalculator build(char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[this.saltLength];
        this.random.nextBytes(salt);
        return PKCS12PBEUtils.createMacCalculator(this.algorithmIdentifier.getAlgorithm(), this.digest, new PKCS12PBEParams(salt, this.iterationCount), password);
    }
}

