/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs.bc;

import com.bes.enterprise.cipher.asn1.pkcs.PKCS12PBEParams;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.ExtendedDigest;
import com.bes.enterprise.cipher.crypto.digests.SHA1Digest;
import com.bes.enterprise.cipher.crypto.generators.PKCS12ParametersGenerator;
import com.bes.enterprise.cipher.crypto.io.CipherInputStream;
import com.bes.enterprise.cipher.crypto.paddings.PaddedBufferedBlockCipher;
import com.bes.enterprise.cipher.operator.GenericKey;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import com.bes.enterprise.cipher.operator.InputDecryptorProvider;
import com.bes.enterprise.cipher.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

