/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs.jcajce;

import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.x509.Certificate;
import com.bes.enterprise.cipher.operator.OutputEncryptor;
import com.bes.enterprise.cipher.pkcs.PKCS12SafeBagBuilder;
import com.bes.enterprise.cipher.pkcs.PKCSIOException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKCS12SafeBagBuilder
extends PKCS12SafeBagBuilder {
    public JcaPKCS12SafeBagBuilder(X509Certificate certificate) throws IOException {
        super(JcaPKCS12SafeBagBuilder.convertCert(certificate));
    }

    private static Certificate convertCert(X509Certificate certificate) throws IOException {
        try {
            return Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new PKCSIOException("cannot encode certificate: " + e.getMessage(), e);
        }
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey, OutputEncryptor encryptor) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()), encryptor);
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

