/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pkcs.jcajce;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.DERNull;
import com.bes.enterprise.cipher.asn1.pkcs.PKCS12PBEParams;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.jcajce.PKCS12Key;
import com.bes.enterprise.cipher.jcajce.io.MacOutputStream;
import com.bes.enterprise.cipher.jcajce.util.DefaultJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.NamedJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.ProviderJcaJceHelper;
import com.bes.enterprise.cipher.operator.GenericKey;
import com.bes.enterprise.cipher.operator.MacCalculator;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.pkcs.PKCS12MacCalculatorBuilder;
import com.bes.enterprise.cipher.pkcs.PKCS12MacCalculatorBuilderProvider;
import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                final PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    final ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                    final Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(algorithm.getId());
                    PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                    final PKCS12Key key = new PKCS12Key(password);
                    mac.init(key, defParams);
                    return new MacCalculator(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(algorithm, pbeParams);
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return new MacOutputStream(mac);
                        }

                        @Override
                        public byte[] getMac() {
                            return mac.doFinal();
                        }

                        @Override
                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), key.getEncoded());
                        }
                    };
                }
                catch (Exception e) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + e.getMessage(), e);
                }
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

