/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.tsp.cms;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.cms.AttributeTable;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.cms.Evidence;
import com.bes.enterprise.cipher.asn1.cms.TimeStampAndCRL;
import com.bes.enterprise.cipher.asn1.cms.TimeStampedData;
import com.bes.enterprise.cipher.asn1.cms.TimeStampedDataParser;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import com.bes.enterprise.cipher.operator.DigestCalculatorProvider;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.tsp.TSPException;
import com.bes.enterprise.cipher.tsp.TimeStampToken;
import com.bes.enterprise.cipher.tsp.TimeStampTokenInfo;
import com.bes.enterprise.cipher.tsp.cms.ImprintDigestInvalidException;
import com.bes.enterprise.cipher.tsp.cms.MetaDataUtil;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class TimeStampDataUtil {
    private final TimeStampAndCRL[] timeStamps;
    private final MetaDataUtil metaDataUtil;

    TimeStampDataUtil(TimeStampedData timeStampedData) {
        this.metaDataUtil = new MetaDataUtil(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampDataUtil(TimeStampedDataParser timeStampedData) throws IOException {
        this.metaDataUtil = new MetaDataUtil(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampToken getTimeStampToken(TimeStampAndCRL timeStampAndCRL) throws CMSException {
        ContentInfo timeStampToken = timeStampAndCRL.getTimeStampToken();
        try {
            TimeStampToken token = new TimeStampToken(timeStampToken);
            return token;
        }
        catch (IOException e) {
            throw new CMSException("unable to parse token data: " + e.getMessage(), e);
        }
        catch (TSPException e) {
            if (e.getCause() instanceof CMSException) {
                throw (CMSException)e.getCause();
            }
            throw new CMSException("token data invalid: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("token data invalid: " + e.getMessage(), e);
        }
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        this.metaDataUtil.initialiseMessageImprintDigestCalculator(calculator);
    }

    DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        try {
            TimeStampToken token = this.getTimeStampToken(this.timeStamps[0]);
            TimeStampTokenInfo info = token.getTimeStampInfo();
            ASN1ObjectIdentifier algOID = info.getMessageImprintAlgOID();
            DigestCalculator calc = calculatorProvider.get(new AlgorithmIdentifier(algOID));
            this.initialiseMessageImprintDigestCalculator(calc);
            return calc;
        }
        catch (CMSException e) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + e.getMessage(), e);
        }
    }

    TimeStampToken[] getTimeStampTokens() throws CMSException {
        TimeStampToken[] tokens = new TimeStampToken[this.timeStamps.length];
        for (int i = 0; i < this.timeStamps.length; ++i) {
            tokens[i] = this.getTimeStampToken(this.timeStamps[i]);
        }
        return tokens;
    }

    TimeStampAndCRL[] getTimeStamps() {
        return this.timeStamps;
    }

    byte[] calculateNextHash(DigestCalculator calculator) throws CMSException {
        TimeStampAndCRL tspToken = this.timeStamps[this.timeStamps.length - 1];
        OutputStream out = calculator.getOutputStream();
        try {
            out.write(tspToken.getEncoded("DER"));
            out.close();
            return calculator.getDigest();
        }
        catch (IOException e) {
            throw new CMSException("exception calculating hash: " + e.getMessage(), e);
        }
    }

    void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        byte[] currentDigest = dataDigest;
        for (int i = 0; i < this.timeStamps.length; ++i) {
            try {
                TimeStampToken token = this.getTimeStampToken(this.timeStamps[i]);
                if (i > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.timeStamps[i - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.compareDigest(token, currentDigest);
                continue;
            }
            catch (IOException e) {
                throw new CMSException("exception calculating hash: " + e.getMessage(), e);
            }
            catch (OperatorCreationException e) {
                throw new CMSException("cannot create digest: " + e.getMessage(), e);
            }
        }
    }

    void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        byte[] encToken;
        byte[] currentDigest = dataDigest;
        try {
            encToken = timeStampToken.getEncoded();
        }
        catch (IOException e) {
            throw new CMSException("exception encoding timeStampToken: " + e.getMessage(), e);
        }
        for (int i = 0; i < this.timeStamps.length; ++i) {
            try {
                TimeStampToken token = this.getTimeStampToken(this.timeStamps[i]);
                if (i > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.timeStamps[i - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.compareDigest(token, currentDigest);
                if (!Arrays.areEqual(token.getEncoded(), encToken)) continue;
                return;
            }
            catch (IOException e) {
                throw new CMSException("exception calculating hash: " + e.getMessage(), e);
            }
            catch (OperatorCreationException e) {
                throw new CMSException("cannot create digest: " + e.getMessage(), e);
            }
        }
        throw new ImprintDigestInvalidException("passed in token not associated with timestamps present", timeStampToken);
    }

    private void compareDigest(TimeStampToken timeStampToken, byte[] digest) throws ImprintDigestInvalidException {
        TimeStampTokenInfo info = timeStampToken.getTimeStampInfo();
        byte[] tsrMessageDigest = info.getMessageImprintDigest();
        if (!Arrays.areEqual(digest, tsrMessageDigest)) {
            throw new ImprintDigestInvalidException("hash calculated is different from MessageImprintDigest found in TimeStampToken", timeStampToken);
        }
    }

    String getFileName() {
        return this.metaDataUtil.getFileName();
    }

    String getMediaType() {
        return this.metaDataUtil.getMediaType();
    }

    AttributeTable getOtherMetaData() {
        return new AttributeTable(this.metaDataUtil.getOtherMetaData());
    }
}

