/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.AsyncCallback;
import com.bes.mq.BESMQConnectionConsumer;
import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.BESMQConnectionMetaData;
import com.bes.mq.BESMQDispatcher;
import com.bes.mq.BESMQInputStream;
import com.bes.mq.BESMQMessageConsumer;
import com.bes.mq.BESMQMessageProducer;
import com.bes.mq.BESMQMessageTransformation;
import com.bes.mq.BESMQOutputStream;
import com.bes.mq.BESMQPrefetchPolicy;
import com.bes.mq.BESMQQueueSession;
import com.bes.mq.BESMQSession;
import com.bes.mq.BESMQTopicSession;
import com.bes.mq.ClientInternalExceptionListener;
import com.bes.mq.Closeable;
import com.bes.mq.ConnectionAudit;
import com.bes.mq.ConnectionClosedException;
import com.bes.mq.ConnectionFailedException;
import com.bes.mq.EnhancedConnection;
import com.bes.mq.MessageTransformer;
import com.bes.mq.NotificationConsumer;
import com.bes.mq.RedeliveryPolicy;
import com.bes.mq.StreamConnection;
import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.broker.region.policy.RedeliveryPolicyMap;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConnectionControl;
import com.bes.mq.command.ConnectionError;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.ConsumerControl;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.ControlCommand;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.ExceptionResponse;
import com.bes.mq.command.FileChunk;
import com.bes.mq.command.FileRequestAck;
import com.bes.mq.command.Message;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerAck;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProtocolFormatInfo;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.RemoveSubscriptionInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.ShutdownInfo;
import com.bes.mq.encryp.BESMQMessageEncryptor;
import com.bes.mq.encryp.EncryptionPolicy;
import com.bes.mq.file.FileRequestor;
import com.bes.mq.file.FileTransferPolicy;
import com.bes.mq.management.JMSConnectionStatsImpl;
import com.bes.mq.management.JMSStatsImpl;
import com.bes.mq.management.StatsCapable;
import com.bes.mq.management.StatsImpl;
import com.bes.mq.notification.DestinationSource;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.state.CommandVisitorAdapter;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.thread.TaskRunnerFactory;
import com.bes.mq.transport.FutureResponse;
import com.bes.mq.transport.ResponseCallback;
import com.bes.mq.transport.Transport;
import com.bes.mq.transport.TransportFilter;
import com.bes.mq.transport.TransportListener;
import com.bes.mq.transport.failover.FailoverTransport;
import com.bes.mq.util.IdGenerator;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.JMSExceptionSupport;
import com.bes.mq.util.LongSequenceGenerator;
import com.bes.mq.util.ServiceSupport;
import com.bes.mq.util.ThreadPoolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BESMQConnection
implements Connection,
TopicConnection,
QueueConnection,
StatsCapable,
Closeable,
StreamConnection,
TransportListener,
EnhancedConnection {
    public static final String DEFAULT_USER = BESMQConnectionFactory.DEFAULT_USER;
    public static final String DEFAULT_PASSWORD = BESMQConnectionFactory.DEFAULT_PASSWORD;
    public static final String DEFAULT_BROKER_URL = "failover://tcp://localhost:3200";
    public static int DEFAULT_THREAD_POOL_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(BESMQConnection.class);
    public final ConcurrentHashMap<BESMQTempDestination, BESMQTempDestination> activeTempDestinations = new ConcurrentHashMap();
    protected boolean dispatchAsync = true;
    protected boolean alwaysSessionAsync = true;
    private TaskRunnerFactory sessionTaskRunner;
    private final ThreadPoolExecutor executor;
    private final ConnectionInfo info;
    private ExceptionListener exceptionListener;
    private ClientInternalExceptionListener clientInternalExceptionListener;
    private boolean clientIDSet;
    private boolean isConnectionInfoSentToBroker;
    private boolean userSpecifiedClientID;
    private BESMQPrefetchPolicy prefetchPolicy = new BESMQPrefetchPolicy();
    private BlobTransferPolicy blobTransferPolicy;
    private FileTransferPolicy fileTransferPolicy;
    private RedeliveryPolicyMap redeliveryPolicyMap;
    private MessageTransformer transformer;
    private boolean disableTimeStampsByDefault;
    private boolean optimizedMessageDispatch = false;
    private boolean copyMessageOnSend = true;
    private boolean useCompression;
    private boolean objectMessageSerializationDefered;
    private boolean syncSendPersistentMessage;
    private boolean optimizeAcknowledge;
    private long optimizeAcknowledgeTimeOut = 0L;
    private long optimizedAckScheduledAckInterval = 0L;
    private boolean nestedMapAndListEnabled = true;
    private boolean useRetroactiveConsumer;
    private boolean exclusiveConsumer;
    private boolean syncSendNonPersistentMessage;
    private int closeTimeout = 15000;
    private boolean watchTopicNotifications = true;
    private long warnAboutUnstartedConnectionTimeout = 500L;
    private int sendTimeout = 0;
    private boolean sendAcksAsync = true;
    private boolean checkForDuplicates = true;
    private boolean queueOnlyConnection = false;
    private transient boolean useEncryption = false;
    private EncryptionPolicy encryptionPolicy;
    private BESMQMessageEncryptor messageEncryptor;
    private final Transport transport;
    private final IdGenerator clientIdGenerator;
    private final JMSStatsImpl factoryStats;
    private final JMSConnectionStatsImpl stats;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean transportFailed = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<BESMQSession> sessions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BESMQConnectionConsumer> connectionConsumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BESMQInputStream> inputStreams = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BESMQOutputStream> outputStreams = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TransportListener> transportListeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<ConsumerId, BESMQDispatcher> dispatchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ProducerId, BESMQMessageProducer> producers = new ConcurrentHashMap();
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final SessionId connectionSessionId;
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator localTransactionIdGenerator = new LongSequenceGenerator();
    private NotificationConsumer notificationConsumer;
    private final CountDownLatch brokerInfoReceived = new CountDownLatch(1);
    private BrokerInfo brokerInfo;
    private IOException firstFailureError;
    private int producerWindowSize = 0;
    private final AtomicInteger protocolVersion = new AtomicInteger(1);
    private final long timeCreated;
    private final ConnectionAudit connectionAudit = new ConnectionAudit();
    private DestinationSource destinationSource;
    private final Object ensureConnectionInfoSentMutex = new Object();
    private boolean useDedicatedTaskRunner;
    protected volatile CountDownLatch transportInterruptionProcessingComplete;
    private long consumerFailoverRedeliveryWaitPeriod;
    private Scheduler scheduler;
    private boolean messagePrioritySupported = true;
    private boolean transactedIndividualAck = false;
    private boolean nonBlockingRedelivery = false;
    private int maxThreadPoolSize = DEFAULT_THREAD_POOL_SIZE;
    private RejectedExecutionHandler rejectedTaskHandler = null;
    private int deliveryMode;
    private Map<String, FileRequestor> fileRequestorMap = new ConcurrentHashMap<String, FileRequestor>();

    protected BESMQConnection(final Transport transport, IdGenerator clientIdGenerator, IdGenerator connectionIdGenerator, JMSStatsImpl factoryStats) throws Exception {
        this.transport = transport;
        this.clientIdGenerator = clientIdGenerator;
        this.factoryStats = factoryStats;
        this.executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "BESMQ Connection Executor: " + transport);
                return thread;
            }
        });
        String uniqueId = connectionIdGenerator.generateId();
        this.info = new ConnectionInfo(new ConnectionId(uniqueId));
        this.info.setManageable(true);
        this.info.setFaultTolerant(transport.isFaultTolerant());
        this.connectionSessionId = new SessionId(this.info.getConnectionId(), -1L);
        this.transport.setTransportListener(this);
        this.stats = new JMSConnectionStatsImpl(this.sessions, this instanceof XAConnection);
        this.factoryStats.addConnection(this);
        this.timeCreated = System.currentTimeMillis();
        this.connectionAudit.setCheckForDuplicates(transport.isFaultTolerant());
    }

    protected void setUserName(String userName) {
        this.info.setUserName(userName);
    }

    protected void setPassword(String password) {
        this.info.setPassword(password);
    }

    public static BESMQConnection makeConnection() throws JMSException {
        BESMQConnectionFactory factory = new BESMQConnectionFactory();
        return (BESMQConnection)factory.createConnection();
    }

    public static BESMQConnection makeConnection(String uri) throws JMSException, URISyntaxException {
        BESMQConnectionFactory factory = new BESMQConnectionFactory(uri);
        return (BESMQConnection)factory.createConnection();
    }

    public static BESMQConnection makeConnection(String user, String password, String uri) throws JMSException, URISyntaxException {
        BESMQConnectionFactory factory = new BESMQConnectionFactory(user, password, new URI(uri));
        return (BESMQConnection)factory.createConnection();
    }

    public JMSConnectionStatsImpl getConnectionStats() {
        return this.stats;
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        if (!transacted) {
            if (acknowledgeMode == 0) {
                throw new JMSException("acknowledgeMode SESSION_TRANSACTED cannot be used for an non-transacted Session");
            }
            if (acknowledgeMode < 0 || acknowledgeMode > 4) {
                throw new JMSException("Invalid acknowledgeMode: " + acknowledgeMode + ". Valid values are Session.AUTO_ACKNOWLEDGE (1), " + "Session.CLIENT_ACKNOWLEDGE (2), Session.DUPS_OK_ACKNOWLEDGE (3), BESMQSession.INDIVIDUAL_ACKNOWLEDGE (4) or for transacted sessions Session.SESSION_TRANSACTED (0)");
            }
        }
        return new BESMQSession(this, this.getNextSessionId(), transacted ? 0 : (acknowledgeMode == 0 ? 1 : acknowledgeMode), this.isDispatchAsync(), this.isAlwaysSessionAsync());
    }

    protected SessionId getNextSessionId() {
        return new SessionId(this.info.getConnectionId(), this.sessionIdGenerator.getNextSequenceId());
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkClosedOrFailed();
        return this.info.getClientId();
    }

    @Override
    public void setClientID(String newClientID) throws JMSException {
        this.checkClosedOrFailed();
        if (this.clientIDSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Setting clientID on a used Connection is not allowed");
        }
        this.info.setClientId(newClientID);
        this.userSpecifiedClientID = true;
        this.ensureConnectionInfoSent();
    }

    public void setDefaultClientID(String clientID) throws JMSException {
        this.info.setClientId(clientID);
        this.userSpecifiedClientID = true;
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosedOrFailed();
        return BESMQConnectionMetaData.INSTANCE;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosedOrFailed();
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosedOrFailed();
        this.exceptionListener = listener;
    }

    public ClientInternalExceptionListener getClientInternalExceptionListener() {
        return this.clientInternalExceptionListener;
    }

    public void setClientInternalExceptionListener(ClientInternalExceptionListener listener) {
        this.clientInternalExceptionListener = listener;
    }

    @Override
    public void start() throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        this.createAndStartMessageEncryptor();
        if (this.started.compareAndSet(false, true)) {
            for (BESMQSession session : this.sessions) {
                session.start();
            }
        }
    }

    protected void createAndStartMessageEncryptor() throws JMSException {
        if (this.encryptionPolicy != null && this.encryptionPolicy.isUseEncryption()) {
            this.messageEncryptor = this.encryptionPolicy.createBESMQMessageEncryptor();
            try {
                this.messageEncryptor.start();
                this.useEncryption = true;
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create("Create and start message encryptor failed", e);
            }
        }
    }

    protected void stopMessageEncryptor() {
        if (this.messageEncryptor != null) {
            try {
                this.messageEncryptor.stop();
            }
            catch (Exception e) {
                LOG.warn("Stop message encryptor failed", e);
            }
            this.messageEncryptor = null;
            this.useEncryption = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        this.closeAllFileMessageRequestor();
        this.checkClosedOrFailed();
        if (this.started.compareAndSet(true, false)) {
            CopyOnWriteArrayList<BESMQSession> copyOnWriteArrayList = this.sessions;
            synchronized (copyOnWriteArrayList) {
                for (BESMQSession s : this.sessions) {
                    s.stop();
                }
            }
            this.stopMessageEncryptor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        boolean interrupted = Thread.interrupted();
        try {
            if (!this.closed.get() && !this.transportFailed.get()) {
                this.stop();
            }
            BESMQConnection bESMQConnection = this;
            synchronized (bESMQConnection) {
                if (!this.closed.get()) {
                    Scheduler scheduler;
                    this.closing.set(true);
                    if (this.destinationSource != null) {
                        this.destinationSource.stop();
                        this.destinationSource = null;
                    }
                    if (this.notificationConsumer != null) {
                        this.notificationConsumer.dispose();
                        this.notificationConsumer = null;
                    }
                    if ((scheduler = this.scheduler) != null) {
                        try {
                            scheduler.stop();
                        }
                        catch (Exception e) {
                            JMSException ex = JMSExceptionSupport.create(e);
                            throw ex;
                        }
                    }
                    long lastDeliveredSequenceId = 0L;
                    for (BESMQSession bESMQSession : this.sessions) {
                        bESMQSession.dispose();
                        lastDeliveredSequenceId = Math.max(lastDeliveredSequenceId, bESMQSession.getLastDeliveredSequenceId());
                    }
                    for (BESMQConnectionConsumer bESMQConnectionConsumer : this.connectionConsumers) {
                        bESMQConnectionConsumer.dispose();
                    }
                    for (BESMQInputStream bESMQInputStream : this.inputStreams) {
                        bESMQInputStream.dispose();
                    }
                    for (BESMQOutputStream bESMQOutputStream : this.outputStreams) {
                        bESMQOutputStream.dispose();
                    }
                    this.cleanUpTempDestinations();
                    if (this.isConnectionInfoSentToBroker) {
                        RemoveInfo removeCommand = this.info.createRemoveCommand();
                        removeCommand.setLastDeliveredSequenceId(lastDeliveredSequenceId);
                        this.doSyncSendPacket(this.info.createRemoveCommand(), this.closeTimeout);
                        this.doAsyncSendPacket(new ShutdownInfo());
                    }
                    this.started.set(false);
                    if (this.sessionTaskRunner != null) {
                        this.sessionTaskRunner.shutdown();
                    }
                    this.closed.set(true);
                    this.closing.set(false);
                }
            }
            Object var10_16 = null;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            try {
                if (this.executor != null) {
                    ThreadPoolUtils.shutdown(this.executor);
                }
            }
            catch (Throwable e) {
                LOG.warn("Error shutting down thread pool: " + this.executor + ". This exception will be ignored.", e);
            }
            ServiceSupport.dispose(this.transport);
            this.factoryStats.removeConnection(this);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        try {
            if (this.executor != null) {
                ThreadPoolUtils.shutdown(this.executor);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error shutting down thread pool: " + this.executor + ". This exception will be ignored.", e);
        }
        ServiceSupport.dispose(this.transport);
        this.factoryStats.removeConnection(this);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosedOrFailed();
        if (this.queueOnlyConnection) {
            throw new IllegalStateException("QueueConnection cannot be used to create Pub/Sub based resources.");
        }
        this.ensureConnectionInfoSent();
        SessionId sessionId = new SessionId(this.info.getConnectionId(), -1L);
        ConsumerInfo info = new ConsumerInfo(new ConsumerId(sessionId, this.consumerIdGenerator.getNextSequenceId()));
        info.setDestination(BESMQMessageTransformation.transformDestination(topic));
        info.setSubscriptionName(subscriptionName);
        info.setSelector(messageSelector);
        info.setPrefetchSize(maxMessages);
        info.setDispatchAsync(this.isDispatchAsync());
        if (info.getDestination().getOptions() != null) {
            HashMap<String, String> options = new HashMap<String, String>(info.getDestination().getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        return new BESMQConnectionConsumer(this, sessionPool, info);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isTransportFailed() {
        return this.transportFailed.get();
    }

    public BESMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(BESMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public Transport getTransportChannel() {
        return this.transport;
    }

    public String getInitializedClientID() throws JMSException {
        this.ensureConnectionInfoSent();
        return this.info.getClientId();
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean timeStampsDisableByDefault) {
        this.disableTimeStampsByDefault = timeStampsDisableByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean dispatchOptimizedMessage) {
        this.optimizedMessageDispatch = dispatchOptimizedMessage;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    public boolean isNestedMapAndListEnabled() {
        return this.nestedMapAndListEnabled;
    }

    public void setNestedMapAndListEnabled(boolean structuredMapsEnabled) {
        this.nestedMapAndListEnabled = structuredMapsEnabled;
    }

    public boolean isExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(boolean exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public void addTransportListener(TransportListener transportListener) {
        this.transportListeners.add(transportListener);
    }

    public void removeTransportListener(TransportListener transportListener) {
        this.transportListeners.remove(transportListener);
    }

    public boolean isUseDedicatedTaskRunner() {
        return this.useDedicatedTaskRunner;
    }

    public void setUseDedicatedTaskRunner(boolean useDedicatedTaskRunner) {
        this.useDedicatedTaskRunner = useDedicatedTaskRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskRunnerFactory getSessionTaskRunner() {
        BESMQConnection bESMQConnection = this;
        synchronized (bESMQConnection) {
            if (this.sessionTaskRunner == null) {
                this.sessionTaskRunner = new TaskRunnerFactory("BESMQ Session Task", 7, false, 1000, this.isUseDedicatedTaskRunner(), this.maxThreadPoolSize);
                this.sessionTaskRunner.setRejectedTaskHandler(this.rejectedTaskHandler);
            }
        }
        return this.sessionTaskRunner;
    }

    public void setSessionTaskRunner(TaskRunnerFactory sessionTaskRunner) {
        this.sessionTaskRunner = sessionTaskRunner;
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    public boolean isStatsEnabled() {
        return this.stats.isEnabled();
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.stats.setEnabled(statsEnabled);
    }

    @Override
    public DestinationSource getDestinationSource() throws JMSException {
        if (this.destinationSource == null) {
            this.destinationSource = new DestinationSource(this);
            this.destinationSource.start();
        }
        return this.destinationSource;
    }

    protected void addSession(BESMQSession session) throws JMSException {
        this.sessions.add(session);
        if (this.sessions.size() > 1 || session.isTransacted()) {
            this.optimizedMessageDispatch = false;
        }
    }

    protected void removeSession(BESMQSession session) {
        this.sessions.remove(session);
        this.removeDispatcher(session);
    }

    protected void addConnectionConsumer(BESMQConnectionConsumer connectionConsumer) throws JMSException {
        this.connectionConsumers.add(connectionConsumer);
    }

    protected void removeConnectionConsumer(BESMQConnectionConsumer connectionConsumer) {
        this.connectionConsumers.remove(connectionConsumer);
        this.removeDispatcher(connectionConsumer);
    }

    @Override
    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new BESMQTopicSession((BESMQSession)this.createSession(transacted, acknowledgeMode));
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, false);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages, false);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        ConsumerId consumerId = this.createConsumerId();
        ConsumerInfo consumerInfo = new ConsumerInfo(consumerId);
        consumerInfo.setDestination(BESMQMessageTransformation.transformDestination(destination));
        consumerInfo.setSelector(messageSelector);
        consumerInfo.setPrefetchSize(maxMessages);
        consumerInfo.setNoLocal(noLocal);
        consumerInfo.setDispatchAsync(this.isDispatchAsync());
        if (consumerInfo.getDestination().getOptions() != null) {
            HashMap<String, String> options = new HashMap<String, String>(consumerInfo.getDestination().getOptions());
            IntrospectionSupport.setProperties(consumerInfo, options, "consumer.");
        }
        return new BESMQConnectionConsumer(this, sessionPool, consumerInfo);
    }

    private ConsumerId createConsumerId() {
        return new ConsumerId(this.connectionSessionId, this.consumerIdGenerator.getNextSequenceId());
    }

    private ProducerId createProducerId() {
        return new ProducerId(this.connectionSessionId, this.producerIdGenerator.getNextSequenceId());
    }

    @Override
    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new BESMQQueueSession((BESMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public void checkClientIDWasManuallySpecified() throws JMSException {
        if (!this.userSpecifiedClientID) {
            throw new IllegalStateException("You cannot create a durable subscriber without specifying a unique clientID on a Connection");
        }
    }

    public void asyncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        this.doAsyncSendPacket(command);
    }

    private void doAsyncSendPacket(Command command) throws JMSException {
        try {
            this.transport.oneway(command);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public void syncSendPacket(final Command command, final AsyncCallback onComplete) throws JMSException {
        if (onComplete == null) {
            this.syncSendPacket(command);
        } else {
            if (this.isClosed()) {
                throw new ConnectionClosedException();
            }
            try {
                this.transport.asyncRequest(command, new ResponseCallback(){

                    public void onCompletion(FutureResponse resp) {
                        Throwable exception = null;
                        try {
                            Response response = resp.getResult();
                            if (response.isException()) {
                                ExceptionResponse er = (ExceptionResponse)response;
                                exception = er.getException();
                            }
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        if (exception != null) {
                            if (exception instanceof JMSException) {
                                onComplete.onException((JMSException)exception);
                            } else {
                                Transport t;
                                if (BESMQConnection.this.isClosed() || BESMQConnection.this.closing.get()) {
                                    LOG.debug("Received an exception but connection is closing");
                                }
                                JMSException jmsEx = null;
                                try {
                                    jmsEx = JMSExceptionSupport.create(exception);
                                }
                                catch (Throwable e) {
                                    LOG.error("Caught an exception trying to create a JMSException for " + exception, e);
                                }
                                if (exception instanceof SecurityException && command instanceof ConnectionInfo && null != (t = BESMQConnection.this.transport)) {
                                    ServiceSupport.dispose(t);
                                }
                                if (jmsEx != null) {
                                    onComplete.onException(jmsEx);
                                }
                            }
                        } else {
                            onComplete.onSuccess();
                        }
                    }
                });
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    public Response syncSendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        try {
            Response response = (Response)this.transport.request(command);
            if (response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                if (er.getException() instanceof JMSException) {
                    throw (JMSException)er.getException();
                }
                if (this.isClosed() || this.closing.get()) {
                    LOG.debug("Received an exception but connection is closing");
                }
                JMSException jmsEx = null;
                try {
                    jmsEx = JMSExceptionSupport.create(er.getException());
                }
                catch (Throwable e) {
                    LOG.error("Caught an exception trying to create a JMSException for " + er.getException(), e);
                }
                if (er.getException() instanceof SecurityException && command instanceof ConnectionInfo) {
                    Transport t = this.transport;
                    if (null != t) {
                        ServiceSupport.dispose(t);
                    }
                    throw new JMSSecurityException(er.getException().getMessage());
                }
                if (jmsEx != null) {
                    throw jmsEx;
                }
            }
            return response;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Response syncSendPacket(Command command, int timeout) throws JMSException {
        if (this.isClosed() || this.closing.get()) {
            throw new ConnectionClosedException();
        }
        return this.doSyncSendPacket(command, timeout);
    }

    public void onewaySendPacket(Command command) throws JMSException {
        if (this.isClosed()) {
            throw new ConnectionClosedException();
        }
        try {
            command.setResponseRequired(false);
            this.transport.oneway(command);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    private Response doSyncSendPacket(Command command, int timeout) throws JMSException {
        try {
            Response response = (Response)(timeout > 0 ? this.transport.request(command, timeout) : this.transport.request(command));
            if (response != null && response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                if (er.getException() instanceof JMSException) {
                    throw (JMSException)er.getException();
                }
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    @Override
    public StatsImpl getStats() {
        return this.stats;
    }

    protected synchronized void checkClosedOrFailed() throws JMSException {
        this.checkClosed();
        if (this.transportFailed.get()) {
            throw new ConnectionFailedException(this.firstFailureError);
        }
    }

    protected synchronized void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw new ConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConnectionInfoSent() throws JMSException {
        Object object = this.ensureConnectionInfoSentMutex;
        synchronized (object) {
            if (this.isConnectionInfoSentToBroker || this.closed.get()) {
                return;
            }
            if (this.info.getClientId() == null || this.info.getClientId().trim().length() == 0) {
                this.info.setClientId(this.clientIdGenerator.generateId());
            }
            this.syncSendPacket(this.info.copy());
            this.isConnectionInfoSentToBroker = true;
            ConsumerId consumerId = new ConsumerId(new SessionId(this.info.getConnectionId(), -1L), this.consumerIdGenerator.getNextSequenceId());
            if (this.watchTopicNotifications) {
                this.notificationConsumer = new NotificationConsumer(this, consumerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionCrediential() throws JMSException {
        Object object = this.ensureConnectionInfoSentMutex;
        synchronized (object) {
            if (this.closed.get()) {
                return;
            }
            ConnectionInfo copy = this.info.copy();
            copy.setClientId(this.clientIdGenerator.generateId());
            this.syncSendPacket(copy);
            this.syncSendPacket(copy.createRemoveCommand());
        }
    }

    public synchronized boolean isWatchTopicNotifications() {
        return this.watchTopicNotifications;
    }

    public synchronized void setWatchTopicNotifications(boolean watchTopicNotifications) {
        this.watchTopicNotifications = watchTopicNotifications;
    }

    public boolean isSyncSendPersistentMessage() {
        return this.syncSendPersistentMessage;
    }

    public void setSyncSendPersistentMessage(boolean syncSendPersistentMessage) {
        this.syncSendPersistentMessage = syncSendPersistentMessage;
    }

    public boolean isSyncSendNonPersistentMessage() {
        return this.syncSendNonPersistentMessage;
    }

    public void setSyncSendNonPersistentMessage(boolean syncSendNonPersistentMessage) {
        this.syncSendNonPersistentMessage = syncSendNonPersistentMessage;
    }

    public boolean isMessagePrioritySupported() {
        return this.messagePrioritySupported;
    }

    public void setMessagePrioritySupported(boolean messagePrioritySupported) {
        this.messagePrioritySupported = messagePrioritySupported;
    }

    public void cleanup() throws JMSException {
        if (this.notificationConsumer != null && !this.isTransportFailed()) {
            this.notificationConsumer.dispose();
            this.notificationConsumer = null;
        }
        for (BESMQSession bESMQSession : this.sessions) {
            bESMQSession.dispose();
        }
        for (BESMQConnectionConsumer bESMQConnectionConsumer : this.connectionConsumers) {
            bESMQConnectionConsumer.dispose();
        }
        for (BESMQInputStream bESMQInputStream : this.inputStreams) {
            bESMQInputStream.dispose();
        }
        for (BESMQOutputStream bESMQOutputStream : this.outputStreams) {
            bESMQOutputStream.dispose();
        }
        if (this.isConnectionInfoSentToBroker) {
            if (!this.transportFailed.get() && !this.closing.get()) {
                this.syncSendPacket(this.info.createRemoveCommand());
            }
            this.isConnectionInfoSentToBroker = false;
        }
        if (this.userSpecifiedClientID) {
            this.info.setClientId(null);
            this.userSpecifiedClientID = false;
        }
        this.clientIDSet = false;
        this.started.set(false);
    }

    public void finalize() throws Throwable {
        Scheduler s = this.scheduler;
        if (s != null) {
            s.stop();
        }
    }

    public void changeUserInfo(String userName, String password) throws JMSException {
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Can't change user information since the connection has been used.");
        }
        this.info.setUserName(userName);
        this.info.setPassword(password);
    }

    public String getResourceManagerId() throws JMSException {
        this.waitForBrokerInfo();
        if (this.brokerInfo == null) {
            throw new JMSException("Connection failed before Broker info was received.");
        }
        return this.brokerInfo.getBrokerId().getValue();
    }

    public String getBrokerName() {
        try {
            this.brokerInfoReceived.await(5L, TimeUnit.SECONDS);
            if (this.brokerInfo == null) {
                return null;
            }
            return this.brokerInfo.getBrokerName();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public String getBrokerAddress() throws JMSException {
        this.checkClosed();
        return this.transport.getRemoteAddress();
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public RedeliveryPolicy getRedeliveryPolicy() throws JMSException {
        return this.redeliveryPolicyMap.getDefaultEntry();
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicyMap.setDefaultEntry(redeliveryPolicy);
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        if (this.blobTransferPolicy == null) {
            this.blobTransferPolicy = this.createBlobTransferPolicy();
        }
        return this.blobTransferPolicy;
    }

    public void setBlobTransferPolicy(BlobTransferPolicy blobTransferPolicy) {
        this.blobTransferPolicy = blobTransferPolicy;
    }

    public FileTransferPolicy getFileTransferPolicy() {
        return this.fileTransferPolicy;
    }

    public void setFileTransferPolicy(FileTransferPolicy fileTransferPolicy) {
        this.fileTransferPolicy = fileTransferPolicy;
    }

    public boolean isAlwaysSessionAsync() {
        return this.alwaysSessionAsync;
    }

    public void setAlwaysSessionAsync(boolean alwaysSessionAsync) {
        this.alwaysSessionAsync = alwaysSessionAsync;
    }

    public boolean isOptimizeAcknowledge() {
        return this.optimizeAcknowledge;
    }

    public void setOptimizeAcknowledge(boolean optimizeAcknowledge) {
        this.optimizeAcknowledge = optimizeAcknowledge;
    }

    public void setOptimizeAcknowledgeTimeOut(long optimizeAcknowledgeTimeOut) {
        this.optimizeAcknowledgeTimeOut = optimizeAcknowledgeTimeOut;
    }

    public long getOptimizeAcknowledgeTimeOut() {
        return this.optimizeAcknowledgeTimeOut;
    }

    public long getWarnAboutUnstartedConnectionTimeout() {
        return this.warnAboutUnstartedConnectionTimeout;
    }

    public void setWarnAboutUnstartedConnectionTimeout(long warnAboutUnstartedConnectionTimeout) {
        this.warnAboutUnstartedConnectionTimeout = warnAboutUnstartedConnectionTimeout;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isSendAcksAsync() {
        return this.sendAcksAsync;
    }

    public void setSendAcksAsync(boolean sendAcksAsync) {
        this.sendAcksAsync = sendAcksAsync;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    private void waitForBrokerInfo() throws JMSException {
        try {
            this.brokerInfoReceived.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JMSExceptionSupport.create(e);
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void addProducer(ProducerId producerId, BESMQMessageProducer producer) {
        this.producers.put(producerId, producer);
    }

    public void removeProducer(ProducerId producerId) {
        this.producers.remove(producerId);
    }

    public void addDispatcher(ConsumerId consumerId, BESMQDispatcher dispatcher) {
        this.dispatchers.put(consumerId, dispatcher);
    }

    public void removeDispatcher(ConsumerId consumerId) {
        this.dispatchers.remove(consumerId);
    }

    @Override
    public void onCommand(Object o) {
        final Command command = (Command)o;
        if (!this.closed.get() && command != null) {
            try {
                command.visit(new CommandVisitorAdapter(){

                    public Response processMessageDispatch(MessageDispatch md) throws Exception {
                        BESMQConnection.this.waitForTransportInterruptionProcessingToComplete();
                        BESMQDispatcher dispatcher = (BESMQDispatcher)BESMQConnection.this.dispatchers.get(md.getConsumerId());
                        if (dispatcher != null) {
                            Message msg = md.getMessage();
                            if (msg != null) {
                                msg = msg.copy();
                                msg.setReadOnlyBody(true);
                                msg.setReadOnlyProperties(true);
                                msg.setRedeliveryCounter(md.getRedeliveryCounter());
                                msg.setConnection(BESMQConnection.this);
                                if (msg instanceof BESMQFileMessage) {
                                    BESMQSession session;
                                    BESMQMessageConsumer consumer = null;
                                    Iterator i$ = BESMQConnection.this.sessions.iterator();
                                    while (i$.hasNext() && (consumer = (session = (BESMQSession)i$.next()).getConsumer(md.getConsumerId())) == null) {
                                    }
                                    BESMQConnection.this.handleFileMessage((BESMQFileMessage)msg, consumer);
                                }
                                md.setMessage(msg);
                            }
                            dispatcher.dispatch(md);
                        }
                        return null;
                    }

                    public Response processProducerAck(ProducerAck pa) throws Exception {
                        BESMQMessageProducer producer;
                        if (pa != null && pa.getProducerId() != null && (producer = (BESMQMessageProducer)BESMQConnection.this.producers.get(pa.getProducerId())) != null) {
                            producer.onProducerAck(pa);
                        }
                        return null;
                    }

                    public Response processBrokerInfo(BrokerInfo info) throws Exception {
                        BESMQConnection.this.brokerInfo = info;
                        BESMQConnection.this.brokerInfoReceived.countDown();
                        BESMQConnection.this.optimizeAcknowledge = (byte)(BESMQConnection.this.optimizeAcknowledge & (!BESMQConnection.this.brokerInfo.isFaultTolerantConfiguration() ? 1 : 0));
                        BESMQConnection.this.getBlobTransferPolicy().setBrokerUploadUrl(info.getBrokerUploadUrl());
                        return null;
                    }

                    public Response processConnectionError(final ConnectionError error) throws Exception {
                        BESMQConnection.this.executor.execute(new Runnable(){

                            public void run() {
                                BESMQConnection.this.onAsyncException(error.getException());
                            }
                        });
                        return null;
                    }

                    public Response processControlCommand(ControlCommand command2) throws Exception {
                        BESMQConnection.this.onControlCommand(command2);
                        return null;
                    }

                    public Response processConnectionControl(ConnectionControl control) throws Exception {
                        BESMQConnection.this.onConnectionControl((ConnectionControl)command);
                        return null;
                    }

                    public Response processConsumerControl(ConsumerControl control) throws Exception {
                        BESMQConnection.this.onConsumerControl((ConsumerControl)command);
                        return null;
                    }

                    public Response processProtocolFormat(ProtocolFormatInfo info) throws Exception {
                        BESMQConnection.this.onProtocolFormatInfo((ProtocolFormatInfo)command);
                        return null;
                    }

                    public Response processFileRequestAck(FileRequestAck fileRequestAck) throws Exception {
                        FileRequestor fileMessageRequestor = (FileRequestor)BESMQConnection.this.fileRequestorMap.get(fileRequestAck.getUid());
                        if (fileMessageRequestor != null) {
                            return fileMessageRequestor.processFileRequestAck(fileRequestAck);
                        }
                        return super.processFileRequestAck(fileRequestAck);
                    }

                    public Response processFileChunk(FileChunk fileChunk) throws Exception {
                        FileRequestor fileMessageRequestor = (FileRequestor)BESMQConnection.this.fileRequestorMap.get(fileChunk.getUid());
                        if (fileMessageRequestor != null) {
                            return fileMessageRequestor.processFileChunk(fileChunk);
                        }
                        return super.processFileChunk(fileChunk);
                    }
                });
            }
            catch (Exception e) {
                this.onClientInternalException(e);
            }
        }
        for (TransportListener listener : this.transportListeners) {
            listener.onCommand(command);
        }
    }

    protected void onProtocolFormatInfo(ProtocolFormatInfo info) {
        this.protocolVersion.set(info.getVersion());
    }

    public void onClientInternalException(final Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.clientInternalExceptionListener != null) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        BESMQConnection.this.clientInternalExceptionListener.onException(error);
                    }
                });
            } else {
                LOG.warn("Async client internal exception occurred with no exception listener registered: " + error.getMessage(), error);
            }
        }
    }

    public void onAsyncException(Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.exceptionListener != null) {
                if (!(error instanceof JMSException)) {
                    error = JMSExceptionSupport.create(error);
                }
                final JMSException e = (JMSException)error;
                this.executor.execute(new Runnable(){

                    public void run() {
                        BESMQConnection.this.exceptionListener.onException(e);
                    }
                });
            } else {
                LOG.debug("Async exception with no exception listener: " + error, error);
            }
        }
    }

    @Override
    public void onException(final IOException error) {
        this.onAsyncException(error);
        if (!this.closing.get() && !this.closed.get()) {
            this.executor.execute(new Runnable(){

                public void run() {
                    BESMQConnection.this.transportFailed(error);
                    ServiceSupport.dispose(BESMQConnection.this.transport);
                    BESMQConnection.this.brokerInfoReceived.countDown();
                    try {
                        BESMQConnection.this.cleanup();
                    }
                    catch (JMSException e) {
                        LOG.warn("Exception during connection cleanup, " + e, e);
                    }
                    for (TransportListener listener : BESMQConnection.this.transportListeners) {
                        listener.onException(error);
                    }
                    if (!this.isContainFailoverTransport(BESMQConnection.this.transport)) {
                        LOG.warn("The connection will be closed.", error);
                        BESMQConnection.this.executor.shutdown();
                    }
                }

                private boolean isContainFailoverTransport(Transport next) {
                    if (next instanceof FailoverTransport) {
                        return true;
                    }
                    if (next instanceof TransportFilter) {
                        next = ((TransportFilter)next).getNext();
                        return this.isContainFailoverTransport(next);
                    }
                    return false;
                }
            });
        }
    }

    @Override
    public void transportInterupted() {
        this.transportInterruptionProcessingComplete = new CountDownLatch(this.dispatchers.size() - (this.notificationConsumer != null ? 1 : 0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transport interrupted, dispatchers: " + this.transportInterruptionProcessingComplete.getCount());
        }
        this.signalInterruptionProcessingNeeded();
        for (BESMQSession s : this.sessions) {
            s.clearMessagesInProgress();
        }
        for (BESMQConnectionConsumer connectionConsumer : this.connectionConsumers) {
            connectionConsumer.clearMessagesInProgress();
        }
        for (TransportListener listener : this.transportListeners) {
            listener.transportInterupted();
        }
    }

    @Override
    public void transportResumed() {
        for (TransportListener listener : this.transportListeners) {
            listener.transportResumed();
        }
    }

    protected BESMQTempDestination createTempDestination(boolean topic) throws JMSException {
        BESMQTempDestination dest = topic ? new BESMQTempTopic(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId()) : new BESMQTempQueue(this.info.getConnectionId(), this.tempDestinationIdGenerator.getNextSequenceId());
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)0);
        info.setDestination(dest);
        this.syncSendPacket(info);
        dest.setConnection(this);
        this.activeTempDestinations.put(dest, dest);
        return dest;
    }

    public void deleteTempDestination(BESMQTempDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        for (BESMQSession session : this.sessions) {
            if (!session.isInUse(destination)) continue;
            throw new JMSException("A consumer is consuming from the temporary destination");
        }
        this.activeTempDestinations.remove(destination);
        DestinationInfo destInfo = new DestinationInfo();
        destInfo.setConnectionId(this.info.getConnectionId());
        destInfo.setOperationType((byte)1);
        destInfo.setDestination(destination);
        destInfo.setTimeout(0L);
        this.syncSendPacket(destInfo);
    }

    public boolean isDeleted(BESMQDestination dest) {
        if (this.notificationConsumer == null) {
            return false;
        }
        return !this.activeTempDestinations.contains(dest);
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public LongSequenceGenerator getLocalTransactionIdGenerator() {
        return this.localTransactionIdGenerator;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void destroyDestination(BESMQDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        DestinationInfo info = new DestinationInfo();
        info.setConnectionId(this.info.getConnectionId());
        info.setOperationType((byte)1);
        info.setDestination(destination);
        info.setTimeout(0L);
        this.syncSendPacket(info);
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean asyncDispatch) {
        this.dispatchAsync = asyncDispatch;
    }

    public boolean isObjectMessageSerializationDefered() {
        return this.objectMessageSerializationDefered;
    }

    public void setObjectMessageSerializationDefered(boolean objectMessageSerializationDefered) {
        this.objectMessageSerializationDefered = objectMessageSerializationDefered;
    }

    @Override
    public InputStream createInputStream(Destination dest) throws JMSException {
        return this.createInputStream(dest, null);
    }

    @Override
    public InputStream createInputStream(Destination dest, String messageSelector) throws JMSException {
        return this.createInputStream(dest, messageSelector, false);
    }

    @Override
    public InputStream createInputStream(Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        return this.createInputStream(dest, messageSelector, noLocal, -1L);
    }

    @Override
    public InputStream createInputStream(Destination dest, String messageSelector, boolean noLocal, long timeout) throws JMSException {
        return this.doCreateInputStream(dest, messageSelector, noLocal, null, timeout);
    }

    @Override
    public InputStream createDurableInputStream(Topic dest, String name) throws JMSException {
        return this.createInputStream(dest, null, false);
    }

    @Override
    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector) throws JMSException {
        return this.createDurableInputStream(dest, name, messageSelector, false);
    }

    @Override
    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableInputStream(dest, name, messageSelector, noLocal, -1L);
    }

    @Override
    public InputStream createDurableInputStream(Topic dest, String name, String messageSelector, boolean noLocal, long timeout) throws JMSException {
        return this.doCreateInputStream(dest, messageSelector, noLocal, name, timeout);
    }

    private InputStream doCreateInputStream(Destination dest, String messageSelector, boolean noLocal, String subName, long timeout) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        return new BESMQInputStream(this, this.createConsumerId(), BESMQDestination.transform(dest), messageSelector, noLocal, subName, this.prefetchPolicy.getInputStreamPrefetch(), timeout);
    }

    @Override
    public OutputStream createOutputStream(Destination dest) throws JMSException {
        return this.createOutputStream(dest, null, 2, 4, 0L);
    }

    public OutputStream createNonPersistentOutputStream(Destination dest) throws JMSException {
        return this.createOutputStream(dest, null, 1, 4, 0L);
    }

    @Override
    public OutputStream createOutputStream(Destination dest, Map<String, Object> streamProperties, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosedOrFailed();
        this.ensureConnectionInfoSent();
        return new BESMQOutputStream(this, this.createProducerId(), BESMQDestination.transform(dest), streamProperties, deliveryMode, priority, timeToLive);
    }

    @Override
    public void unsubscribe(String name) throws InvalidDestinationException, JMSException {
        this.checkClosedOrFailed();
        RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
        rsi.setConnectionId(this.getConnectionInfo().getConnectionId());
        rsi.setSubscriptionName(name);
        rsi.setClientId(this.getConnectionInfo().getClientId());
        this.syncSendPacket(rsi);
    }

    void send(BESMQDestination destination, BESMQMessage msg, MessageId messageId, int deliveryMode, int priority, long timeToLive, boolean async) throws JMSException {
        this.checkClosedOrFailed();
        if (destination.isTemporary() && this.isDeleted(destination)) {
            throw new JMSException("Cannot publish to a deleted Destination: " + destination);
        }
        msg.setJMSDestination(destination);
        msg.setJMSDeliveryMode(deliveryMode);
        long expiration = 0L;
        if (!this.isDisableTimeStampsByDefault()) {
            long timeStamp = System.currentTimeMillis();
            msg.setJMSTimestamp(timeStamp);
            if (timeToLive > 0L) {
                expiration = timeToLive + timeStamp;
            }
        }
        msg.setJMSExpiration(expiration);
        msg.setJMSPriority(priority);
        msg.setJMSRedelivered(false);
        msg.setMessageId(messageId);
        msg.onSend();
        msg.setProducerId(msg.getMessageId().getProducerId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending message: " + msg);
        }
        if (async) {
            this.asyncSendPacket(msg);
        } else {
            this.syncSendPacket(msg);
        }
    }

    protected void handleFileMessage(BESMQFileMessage fileMessage, BESMQMessageConsumer consumer) throws JMSException {
        String uid = fileMessage.getStringProperty("BESMQ_FT_FILE_UID");
        if (uid == null || uid.length() == 0) {
            LOG.warn("FileMessage's uid is empty, MessageID: " + fileMessage.getJMSMessageID());
            return;
        }
        FileRequestor fileMessageRequestor = this.fileRequestorMap.get(uid);
        if (fileMessageRequestor != null && !fileMessageRequestor.isStopped()) {
            fileMessageRequestor.attatched(consumer, fileMessage);
        } else {
            fileMessageRequestor = new FileRequestor(this, consumer, uid);
            this.fileRequestorMap.put(uid, fileMessageRequestor);
            fileMessageRequestor.attatched(consumer, fileMessage);
            fileMessageRequestor.processFileMessage(fileMessage);
        }
    }

    public void removeFileMessageRequestor(String uid) {
        this.fileRequestorMap.remove(uid);
    }

    public FileRequestor getFileMessageRequestor(String uid) {
        return this.fileRequestorMap.get(uid);
    }

    public void closeAllFileMessageRequestor() {
        Iterator<FileRequestor> it = this.fileRequestorMap.values().iterator();
        while (it.hasNext()) {
            it.next().stop();
        }
        this.fileRequestorMap.clear();
    }

    public void addOutputStream(BESMQOutputStream stream) {
        this.outputStreams.add(stream);
    }

    public void removeOutputStream(BESMQOutputStream stream) {
        this.outputStreams.remove(stream);
    }

    public void addInputStream(BESMQInputStream stream) {
        this.inputStreams.add(stream);
    }

    public void removeInputStream(BESMQInputStream stream) {
        this.inputStreams.remove(stream);
    }

    protected void onControlCommand(ControlCommand command) {
        String text = command.getCommand();
        if (text != null && "shutdown".equals(text)) {
            LOG.info("JVM told to shutdown");
            System.exit(0);
        }
    }

    protected void onConnectionControl(ConnectionControl command) {
        if (command.isFaultTolerant()) {
            this.optimizeAcknowledge = false;
            for (BESMQSession s : this.sessions) {
                s.setOptimizeAcknowledge(false);
            }
        }
    }

    protected void onConsumerControl(ConsumerControl command) {
        if (command.isClose()) {
            for (BESMQSession session : this.sessions) {
                session.close(command.getConsumerId());
            }
        } else {
            for (BESMQSession session : this.sessions) {
                session.setPrefetchSize(command.getConsumerId(), command.getPrefetch());
            }
        }
    }

    protected void transportFailed(IOException error) {
        this.transportFailed.set(true);
        if (this.firstFailureError == null) {
            this.firstFailureError = error;
        }
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public String toString() {
        return "BESMQConnection {id=" + this.info.getConnectionId() + ",clientId=" + this.info.getClientId() + ",started=" + this.started.get() + "}";
    }

    protected BlobTransferPolicy createBlobTransferPolicy() {
        return new BlobTransferPolicy();
    }

    public int getProtocolVersion() {
        return this.protocolVersion.get();
    }

    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public void setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
    }

    public void setAuditDepth(int auditDepth) {
        this.connectionAudit.setAuditDepth(auditDepth);
    }

    public void setAuditMaximumProducerNumber(int auditMaximumProducerNumber) {
        this.connectionAudit.setAuditMaximumProducerNumber(auditMaximumProducerNumber);
    }

    protected void removeDispatcher(BESMQDispatcher dispatcher) {
        this.connectionAudit.removeDispatcher(dispatcher);
    }

    protected boolean isDuplicate(BESMQDispatcher dispatcher, Message message) {
        return this.checkForDuplicates && this.connectionAudit.isDuplicate(dispatcher, message);
    }

    protected void rollbackDuplicate(BESMQDispatcher dispatcher, Message message) {
        this.connectionAudit.rollbackDuplicate(dispatcher, message);
    }

    public IOException getFirstFailureError() {
        return this.firstFailureError;
    }

    protected void waitForTransportInterruptionProcessingToComplete() throws InterruptedException {
        CountDownLatch cdl = this.transportInterruptionProcessingComplete;
        if (cdl != null) {
            if (!this.closed.get() && !this.transportFailed.get() && cdl.getCount() > 0L) {
                LOG.warn("Dispatch paused, waiting for outstanding dispatch interruption processing (" + cdl.getCount() + ") to complete..");
                cdl.await(10L, TimeUnit.SECONDS);
            }
            this.signalInterruptionProcessingComplete();
        }
    }

    protected void transportInterruptionProcessingComplete() {
        CountDownLatch cdl = this.transportInterruptionProcessingComplete;
        if (cdl != null) {
            cdl.countDown();
            try {
                this.signalInterruptionProcessingComplete();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void signalInterruptionProcessingComplete() throws InterruptedException {
        CountDownLatch cdl = this.transportInterruptionProcessingComplete;
        if (cdl.getCount() == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TransportInterruptionProcessingComplete for: " + this.getConnectionInfo().getConnectionId());
            }
            this.transportInterruptionProcessingComplete = null;
            FailoverTransport failoverTransport = this.transport.narrow(FailoverTransport.class);
            if (failoverTransport != null) {
                failoverTransport.connectionInterruptProcessingComplete(this.getConnectionInfo().getConnectionId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Notified failover transport (" + failoverTransport + ") of interruption completion for: " + this.getConnectionInfo().getConnectionId());
                }
            }
        }
    }

    private void signalInterruptionProcessingNeeded() {
        FailoverTransport failoverTransport = this.transport.narrow(FailoverTransport.class);
        if (failoverTransport != null) {
            failoverTransport.getStateTracker().transportInterrupted(this.getConnectionInfo().getConnectionId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notified failover transport (" + failoverTransport + ") of pending interruption processing for: " + this.getConnectionInfo().getConnectionId());
            }
        }
    }

    public void setConsumerFailoverRedeliveryWaitPeriod(long consumerFailoverRedeliveryWaitPeriod) {
        this.consumerFailoverRedeliveryWaitPeriod = consumerFailoverRedeliveryWaitPeriod;
    }

    public long getConsumerFailoverRedeliveryWaitPeriod() {
        return this.consumerFailoverRedeliveryWaitPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler getScheduler() throws JMSException {
        Scheduler result = this.scheduler;
        if (result == null) {
            BESMQConnection bESMQConnection = this;
            synchronized (bESMQConnection) {
                result = this.scheduler;
                if (result == null) {
                    this.checkClosed();
                    try {
                        result = this.scheduler = new Scheduler("BESMQConnection[" + this.info.getConnectionId().getValue() + "] Scheduler");
                        this.scheduler.start();
                    }
                    catch (Exception e) {
                        throw JMSExceptionSupport.create(e);
                    }
                }
            }
        }
        return result;
    }

    protected ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public boolean isCheckForDuplicates() {
        return this.checkForDuplicates;
    }

    public void setCheckForDuplicates(boolean checkForDuplicates) {
        this.checkForDuplicates = checkForDuplicates;
    }

    public boolean isTransactedIndividualAck() {
        return this.transactedIndividualAck;
    }

    public void setTransactedIndividualAck(boolean transactedIndividualAck) {
        this.transactedIndividualAck = transactedIndividualAck;
    }

    public boolean isNonBlockingRedelivery() {
        return this.nonBlockingRedelivery;
    }

    public void setNonBlockingRedelivery(boolean nonBlockingRedelivery) {
        this.nonBlockingRedelivery = nonBlockingRedelivery;
    }

    public void cleanUpTempDestinations() {
        if (this.activeTempDestinations == null || this.activeTempDestinations.isEmpty()) {
            return;
        }
        for (Map.Entry<BESMQTempDestination, BESMQTempDestination> entry : this.activeTempDestinations.entrySet()) {
            try {
                String thisConnectionId;
                BESMQTempDestination dest = entry.getValue();
                String string = thisConnectionId = this.info.getConnectionId() == null ? "" : this.info.getConnectionId().toString();
                if (dest.getConnectionId() == null || !dest.getConnectionId().equals(thisConnectionId)) continue;
                this.deleteTempDestination(entry.getValue());
            }
            catch (Exception exception) {}
        }
    }

    public void setRedeliveryPolicyMap(RedeliveryPolicyMap redeliveryPolicyMap) {
        this.redeliveryPolicyMap = redeliveryPolicyMap;
    }

    public RedeliveryPolicyMap getRedeliveryPolicyMap() {
        return this.redeliveryPolicyMap;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    BESMQConnection enforceQueueOnlyConnection() {
        this.queueOnlyConnection = true;
        return this;
    }

    public RejectedExecutionHandler getRejectedTaskHandler() {
        return this.rejectedTaskHandler;
    }

    public void setRejectedTaskHandler(RejectedExecutionHandler rejectedTaskHandler) {
        this.rejectedTaskHandler = rejectedTaskHandler;
    }

    public long getOptimizedAckScheduledAckInterval() {
        return this.optimizedAckScheduledAckInterval;
    }

    public void setOptimizedAckScheduledAckInterval(long optimizedAckScheduledAckInterval) {
        this.optimizedAckScheduledAckInterval = optimizedAckScheduledAckInterval;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public boolean isUseEncryption() {
        return this.useEncryption;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public BESMQMessageEncryptor getMessageEncryptor() {
        return this.messageEncryptor;
    }

    public void setMessageEncryptor(BESMQMessageEncryptor messageEncryptor) {
        this.messageEncryptor = messageEncryptor;
    }
}

