/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQDispatcher;
import com.bes.mq.BESMQQueueSession;
import com.bes.mq.BESMQSession;
import com.bes.mq.BESMQTopicSession;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.MessageDispatch;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class BESMQConnectionConsumer
implements ConnectionConsumer,
BESMQDispatcher {
    private BESMQConnection connection;
    private ServerSessionPool sessionPool;
    private ConsumerInfo consumerInfo;
    private boolean closed;

    protected BESMQConnectionConsumer(BESMQConnection theConnection, ServerSessionPool theSessionPool, ConsumerInfo theConsumerInfo) throws JMSException {
        this.connection = theConnection;
        this.sessionPool = theSessionPool;
        this.consumerInfo = theConsumerInfo;
        this.connection.addConnectionConsumer(this);
        this.connection.addDispatcher(this.consumerInfo.getConsumerId(), this);
        this.connection.asyncSendPacket(this.consumerInfo);
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The Connection Consumer is closed");
        }
        return this.sessionPool;
    }

    public void close() throws JMSException {
        if (!this.closed) {
            this.dispose();
            this.connection.asyncSendPacket(this.consumerInfo.createRemoveCommand());
        }
    }

    public void dispose() {
        if (!this.closed) {
            this.connection.removeDispatcher(this.consumerInfo.getConsumerId());
            this.connection.removeConnectionConsumer(this);
            this.closed = true;
        }
    }

    public void dispatch(MessageDispatch messageDispatch) {
        try {
            messageDispatch.setConsumer(this);
            ServerSession serverSession = this.sessionPool.getServerSession();
            Session s = serverSession.getSession();
            BESMQSession session = null;
            if (s instanceof BESMQSession) {
                session = (BESMQSession)s;
            } else if (s instanceof BESMQTopicSession) {
                BESMQTopicSession topicSession = (BESMQTopicSession)s;
                session = (BESMQSession)topicSession.getNext();
            } else if (s instanceof BESMQQueueSession) {
                BESMQQueueSession queueSession = (BESMQQueueSession)s;
                session = (BESMQSession)queueSession.getNext();
            } else {
                this.connection.onClientInternalException(new JMSException("Session pool provided an invalid session type: " + s.getClass()));
                return;
            }
            session.dispatch(messageDispatch);
            serverSession.start();
        }
        catch (JMSException e) {
            this.connection.onAsyncException(e);
        }
    }

    public String toString() {
        return "BESMQConnectionConsumer { value=" + this.consumerInfo.getConsumerId() + " }";
    }

    public void clearMessagesInProgress() {
        this.connection.transportInterruptionProcessingComplete();
    }
}

