/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BESMQConnectionMetaData
implements ConnectionMetaData {
    public static final String PROVIDER_VERSION;
    public static final int PROVIDER_MAJOR_VERSION;
    public static final int PROVIDER_MINOR_VERSION;
    public static final BESMQConnectionMetaData INSTANCE;

    private BESMQConnectionMetaData() {
    }

    @Override
    public String getJMSVersion() {
        return "1.1";
    }

    @Override
    public int getJMSMajorVersion() {
        return 1;
    }

    @Override
    public int getJMSMinorVersion() {
        return 1;
    }

    @Override
    public String getJMSProviderName() {
        return "BES MQ";
    }

    @Override
    public String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    @Override
    public int getProviderMajorVersion() {
        return PROVIDER_MAJOR_VERSION;
    }

    @Override
    public int getProviderMinorVersion() {
        return PROVIDER_MINOR_VERSION;
    }

    @Override
    public Enumeration<String> getJMSXPropertyNames() {
        Vector<String> jmxProperties = new Vector<String>();
        jmxProperties.add("JMSXGroupID");
        jmxProperties.add("JMSXGroupSeq");
        jmxProperties.add("JMSXDeliveryCount");
        jmxProperties.add("JMSXProducerTXID");
        return jmxProperties.elements();
    }

    static {
        INSTANCE = new BESMQConnectionMetaData();
        String version = null;
        int major = 0;
        int minor = 0;
        try {
            Package p = Package.getPackage("com.bes.mq");
            if (p != null) {
                version = p.getImplementationVersion();
                Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                Matcher m = pattern.matcher(version);
                if (m.matches()) {
                    major = Integer.parseInt(m.group(1));
                    minor = Integer.parseInt(m.group(2));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROVIDER_VERSION = version;
        PROVIDER_MAJOR_VERSION = major;
        PROVIDER_MINOR_VERSION = minor;
    }
}

