/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.AsyncCallback;
import com.bes.mq.BESMQMessageProducerSupport;
import com.bes.mq.BESMQSession;
import com.bes.mq.ConfigurationException;
import com.bes.mq.Disposable;
import com.bes.mq.MessageTransformer;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.ProducerAck;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.file.FileTransferListener;
import com.bes.mq.management.JMSProducerStatsImpl;
import com.bes.mq.management.StatsCapable;
import com.bes.mq.management.StatsImpl;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.usage.MemoryUsage;
import com.bes.mq.util.IntrospectionSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;

public class BESMQMessageProducer
extends BESMQMessageProducerSupport
implements StatsCapable,
Disposable {
    private static final Logger LOG = LoggerFactory.getLogger(BESMQMessageProducer.class);
    protected ProducerInfo info;
    protected boolean closed;
    private final JMSProducerStatsImpl stats;
    private AtomicLong messageSequence;
    private final long startTime;
    private MessageTransformer transformer;
    private MemoryUsage producerWindow;
    private FileTransferListener fileTransferListener = null;
    static final AsyncCallback ONEWAY_CB = new AsyncCallback(){

        public void onException(JMSException arg0) {
        }

        public void onSuccess() {
        }
    };

    protected BESMQMessageProducer(BESMQSession session, ProducerId producerId, BESMQDestination destination, int sendTimeout) throws JMSException {
        super(session);
        this.info = new ProducerInfo(producerId);
        this.info.setWindowSize(session.connection.getProducerWindowSize());
        if (destination != null && destination.getOptions() != null) {
            Map<String, Object> options = IntrospectionSupport.extractProperties(new HashMap<String, String>(destination.getOptions()), "producer.");
            IntrospectionSupport.setProperties(this.info, options);
            if (options.size() > 0) {
                String msg = "There are " + options.size() + " producer options that couldn't be set on the producer." + " Check the options are spelled correctly." + " Unknown parameters=[" + options + "]." + " This producer cannot be started.";
                LOG.warn(msg);
                throw new ConfigurationException(msg);
            }
        }
        this.info.setDestination(destination);
        if (this.info.getWindowSize() > 0) {
            this.producerWindow = new MemoryUsage("Producer Window: " + producerId);
            this.producerWindow.setExecutor(session.getConnectionExecutor());
            this.producerWindow.setLimit(this.info.getWindowSize());
            this.producerWindow.start();
        }
        this.defaultDeliveryMode = session.connection.getDeliveryMode();
        this.defaultPriority = 4;
        this.defaultTimeToLive = 0L;
        this.startTime = System.currentTimeMillis();
        this.messageSequence = new AtomicLong(0L);
        this.stats = new JMSProducerStatsImpl(session.getSessionStats(), destination);
        this.session.addProducer(this);
        this.session.asyncSendPacket(this.info);
        this.setSendTimeout(sendTimeout);
        this.setTransformer(session.getTransformer());
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSProducerStatsImpl getProducerStats() {
        return this.stats;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.info.getDestination();
    }

    public void close() throws JMSException {
        if (!this.closed) {
            this.dispose();
            this.session.asyncSendPacket(this.info.createRemoveCommand());
        }
    }

    public void dispose() {
        if (!this.closed) {
            this.session.removeProducer(this);
            if (this.producerWindow != null) {
                this.producerWindow.stop();
            }
            this.closed = true;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The producer is closed");
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Message message, AsyncCallback onComplete) throws JMSException {
        this.send(this.getDestination(), message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, onComplete);
    }

    public void send(Destination destination, Message message, AsyncCallback onComplete) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, onComplete);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, AsyncCallback onComplete) throws JMSException {
        this.send(this.getDestination(), message, deliveryMode, priority, timeToLive, onComplete);
    }

    public void sendOneway(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(destination, message, deliveryMode, priority, timeToLive, ONEWAY_CB);
    }

    public void sendOneway(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, ONEWAY_CB);
    }

    public void sendOneway(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, ONEWAY_CB);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, AsyncCallback onComplete) throws JMSException {
        Message transformedMessage;
        BESMQDestination dest;
        this.checkClosed();
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (destination.equals(this.info.getDestination())) {
            dest = (BESMQDestination)destination;
        } else if (this.info.getDestination() == null) {
            dest = BESMQDestination.transform(destination);
        } else {
            throw new UnsupportedOperationException("This producer can only send messages to: " + this.info.getDestination().getPhysicalName());
        }
        if (dest == null) {
            throw new JMSException("No destination specified");
        }
        message.setJMSDestination(destination);
        if (this.transformer != null && (transformedMessage = this.transformer.producerTransform(this.session, this, message)) != null) {
            message = transformedMessage;
        }
        if (this.producerWindow != null) {
            try {
                this.producerWindow.waitForSpace();
            }
            catch (InterruptedException e) {
                throw new JMSException("Send aborted due to thread interrupt.");
            }
        }
        this.session.send(this, dest, message, deliveryMode, priority, timeToLive, this.producerWindow, this.sendTimeout, onComplete);
        this.stats.onMessage();
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getMessageSequence() {
        return this.messageSequence.incrementAndGet();
    }

    protected void setMessageSequence(AtomicLong messageSequence) {
        this.messageSequence = messageSequence;
    }

    protected ProducerInfo getProducerInfo() {
        return this.info != null ? this.info : null;
    }

    protected void setProducerInfo(ProducerInfo info) {
        this.info = info;
    }

    public String toString() {
        return "BESMQMessageProducer { value=" + this.info.getProducerId() + " }";
    }

    public void onProducerAck(ProducerAck pa) {
        if (this.producerWindow != null) {
            this.producerWindow.decreaseUsage(pa.getSize());
        }
    }

    public void waitForSpace() throws InterruptedException {
        if (this.producerWindow != null) {
            this.producerWindow.waitForSpace();
        }
    }

    public void increaseUsage(long value) {
        if (this.producerWindow != null) {
            this.producerWindow.increaseUsage(value);
        }
    }

    public void decreaseUsage(long value) {
        if (this.producerWindow != null) {
            this.producerWindow.decreaseUsage(value);
        }
    }

    public FileTransferListener getFileTransferListener() {
        return this.fileTransferListener;
    }

    public void setFileTransferListener(FileTransferListener fileTransferListener) {
        this.fileTransferListener = fileTransferListener;
    }
}

