/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BlobMessage;
import com.bes.mq.blob.BlobDownloader;
import com.bes.mq.command.BESMQBlobMessage;
import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQObjectMessage;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQStreamMessage;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTextMessage;
import com.bes.mq.command.BESMQTopic;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public final class BESMQMessageTransformation {
    private BESMQMessageTransformation() {
    }

    public static BESMQDestination transformDestination(Destination destination) throws JMSException {
        BESMQDestination besMQDestination = null;
        if (destination != null) {
            if (destination instanceof BESMQDestination) {
                return (BESMQDestination)destination;
            }
            if (destination instanceof TemporaryQueue) {
                besMQDestination = new BESMQTempQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                besMQDestination = new BESMQTempTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                besMQDestination = new BESMQQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                besMQDestination = new BESMQTopic(((Topic)destination).getTopicName());
            }
        }
        return besMQDestination;
    }

    public static BESMQMessage transformMessage(Message message, BESMQConnection connection) throws JMSException {
        if (message instanceof BESMQMessage) {
            return (BESMQMessage)message;
        }
        BESMQMessage activeMessage = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            BESMQBytesMessage msg = new BESMQBytesMessage();
            msg.setConnection(connection);
            try {
                while (true) {
                    msg.writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            BESMQMapMessage msg = new BESMQMapMessage();
            msg.setConnection(connection);
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                msg.setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            BESMQObjectMessage msg = new BESMQObjectMessage();
            msg.setConnection(connection);
            msg.setObject(objMsg.getObject());
            msg.storeContent();
            activeMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            BESMQStreamMessage msg = new BESMQStreamMessage();
            msg.setConnection(connection);
            Object obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    msg.writeObject(obj);
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            BESMQTextMessage msg = new BESMQTextMessage();
            msg.setConnection(connection);
            msg.setText(textMsg.getText());
            activeMessage = msg;
        } else if (message instanceof BlobMessage) {
            BlobMessage blobMessage = (BlobMessage)message;
            BESMQBlobMessage msg = new BESMQBlobMessage();
            msg.setConnection(connection);
            msg.setBlobDownloader(new BlobDownloader(connection.getBlobTransferPolicy()));
            try {
                msg.setURL(blobMessage.getURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else {
            activeMessage = new BESMQMessage();
            activeMessage.setConnection(connection);
        }
        BESMQMessageTransformation.copyProperties(message, activeMessage);
        return activeMessage;
    }

    public static void copyProperties(Message fromMessage, Message toMessage) throws JMSException {
        toMessage.setJMSMessageID(fromMessage.getJMSMessageID());
        toMessage.setJMSCorrelationID(fromMessage.getJMSCorrelationID());
        toMessage.setJMSReplyTo(BESMQMessageTransformation.transformDestination(fromMessage.getJMSReplyTo()));
        toMessage.setJMSDestination(BESMQMessageTransformation.transformDestination(fromMessage.getJMSDestination()));
        toMessage.setJMSDeliveryMode(fromMessage.getJMSDeliveryMode());
        toMessage.setJMSRedelivered(fromMessage.getJMSRedelivered());
        toMessage.setJMSType(fromMessage.getJMSType());
        toMessage.setJMSExpiration(fromMessage.getJMSExpiration());
        toMessage.setJMSPriority(fromMessage.getJMSPriority());
        toMessage.setJMSTimestamp(fromMessage.getJMSTimestamp());
        Enumeration propertyNames = fromMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = fromMessage.getObjectProperty(name);
            toMessage.setObjectProperty(name, obj);
        }
    }
}

