/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQConnection;
import com.bes.mq.Disposable;
import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.util.IOExceptionSupport;
import com.bes.mq.util.IntrospectionSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BESMQOutputStream
extends OutputStream
implements Disposable {
    protected int count;
    final byte[] buffer;
    private final BESMQConnection connection;
    private final Map<String, Object> properties;
    private final ProducerInfo info;
    private long messageSequence;
    private boolean closed;
    private final int deliveryMode;
    private final int priority;
    private final long timeToLive;
    private boolean alwaysSyncSend = false;
    public static final String BMQ_STREAM_CHUNK_SIZE = "BMQ_STREAM_CHUNK_SIZE";

    public BESMQOutputStream(BESMQConnection connection, ProducerId producerId, BESMQDestination destination, Map<String, Object> properties, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Integer chunkSize;
        this.connection = connection;
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.timeToLive = timeToLive;
        this.properties = properties == null ? null : new HashMap<String, Object>(properties);
        Integer n = chunkSize = this.properties == null ? null : (Integer)this.properties.get(BMQ_STREAM_CHUNK_SIZE);
        if (chunkSize == null) {
            chunkSize = 65536;
        } else {
            if (chunkSize < 1) {
                throw new IllegalArgumentException("Chunk size must be greater then 0");
            }
            chunkSize = chunkSize * 1024;
        }
        this.buffer = new byte[chunkSize.intValue()];
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        this.info = new ProducerInfo(producerId);
        if (destination.getOptions() != null) {
            HashMap<String, String> options = new HashMap<String, String>(destination.getOptions());
            IntrospectionSupport.setProperties(this, options, "producer.");
            IntrospectionSupport.setProperties(this.info, options, "producer.");
        }
        this.info.setDestination(destination);
        this.connection.addOutputStream(this);
        this.connection.asyncSendPacket(this.info);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            try {
                this.send(new BESMQMessage(), true);
                this.dispose();
                this.connection.asyncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                IOExceptionSupport.create(e);
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.closed) {
            this.connection.removeOutputStream(this);
            this.closed = true;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.buffer[this.count++] = (byte)b;
        if (this.count == this.buffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int max = Math.min(len, this.buffer.length - this.count);
            System.arraycopy(b, off, this.buffer, this.count, max);
            len -= max;
            this.count += max;
            off += max;
            if (this.count != this.buffer.length) continue;
            this.flushBuffer();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        if (this.count != 0) {
            try {
                BESMQBytesMessage msg = new BESMQBytesMessage();
                msg.writeBytes(this.buffer, 0, this.count);
                this.send(msg, false);
            }
            catch (JMSException e) {
                throw IOExceptionSupport.create(e);
            }
            this.count = 0;
        }
    }

    private void send(BESMQMessage msg, boolean eosMessage) throws JMSException {
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Object value = this.properties.get(key);
                msg.setObjectProperty(key, value);
            }
        }
        msg.setType("com.bes.mq.Stream");
        msg.setGroupID(this.info.getProducerId().toString());
        if (eosMessage) {
            msg.setGroupSequence(-1);
        } else {
            msg.setGroupSequence((int)this.messageSequence);
        }
        MessageId id = new MessageId(this.info.getProducerId(), this.messageSequence++);
        this.connection.send(this.info.getDestination(), msg, id, this.deliveryMode, this.priority, this.timeToLive, !eosMessage && !this.isAlwaysSyncSend());
    }

    public String toString() {
        return "BESMQOutputStream { producerId=" + this.info.getProducerId() + " }";
    }

    public boolean isAlwaysSyncSend() {
        return this.alwaysSyncSend;
    }

    public void setAlwaysSyncSend(boolean alwaysSyncSend) {
        this.alwaysSyncSend = alwaysSyncSend;
    }
}

