/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.AsyncCallback;
import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQDispatcher;
import com.bes.mq.BESMQMessageConsumer;
import com.bes.mq.BESMQMessageProducer;
import com.bes.mq.BESMQMessageTransformation;
import com.bes.mq.BESMQPrefetchPolicy;
import com.bes.mq.BESMQQueueBrowser;
import com.bes.mq.BESMQQueueReceiver;
import com.bes.mq.BESMQQueueSender;
import com.bes.mq.BESMQSessionExecutor;
import com.bes.mq.BESMQTopicPublisher;
import com.bes.mq.BESMQTopicSubscriber;
import com.bes.mq.BlobMessage;
import com.bes.mq.CustomDestination;
import com.bes.mq.FileMessage;
import com.bes.mq.MessageDispatchChannel;
import com.bes.mq.MessageTransformer;
import com.bes.mq.RedeliveryPolicy;
import com.bes.mq.TransactionContext;
import com.bes.mq.blob.BlobDownloader;
import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.blob.BlobUploader;
import com.bes.mq.command.BESMQBlobMessage;
import com.bes.mq.command.BESMQBytesMessage;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQFileMessage;
import com.bes.mq.command.BESMQMapMessage;
import com.bes.mq.command.BESMQMessage;
import com.bes.mq.command.BESMQObjectMessage;
import com.bes.mq.command.BESMQQueue;
import com.bes.mq.command.BESMQStreamMessage;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.command.BESMQTempQueue;
import com.bes.mq.command.BESMQTempTopic;
import com.bes.mq.command.BESMQTextMessage;
import com.bes.mq.command.BESMQTopic;
import com.bes.mq.command.Command;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.MessageId;
import com.bes.mq.command.ProducerId;
import com.bes.mq.command.RemoveInfo;
import com.bes.mq.command.Response;
import com.bes.mq.command.SessionId;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.management.JMSSessionStatsImpl;
import com.bes.mq.management.StatsCapable;
import com.bes.mq.management.StatsImpl;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.transaction.Synchronization;
import com.bes.mq.usage.MemoryUsage;
import com.bes.mq.util.Callback;
import com.bes.mq.util.JMSExceptionSupport;
import com.bes.mq.util.LongSequenceGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BESMQSession
implements Session,
QueueSession,
TopicSession,
StatsCapable,
BESMQDispatcher {
    public static final int INDIVIDUAL_ACKNOWLEDGE = 4;
    public static final int MAX_ACK_CONSTANT = 4;
    private static final Logger LOG = LoggerFactory.getLogger(BESMQSession.class);
    private final ThreadPoolExecutor connectionExecutor;
    protected int acknowledgementMode;
    protected final BESMQConnection connection;
    protected final SessionInfo info;
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    protected final LongSequenceGenerator deliveryIdGenerator = new LongSequenceGenerator();
    protected final BESMQSessionExecutor executor;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final CopyOnWriteArrayList<BESMQMessageConsumer> consumers = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<BESMQMessageProducer> producers = new CopyOnWriteArrayList();
    protected boolean closed;
    private volatile boolean synchronizationRegistered;
    protected boolean asyncDispatch;
    protected boolean sessionAsyncDispatch;
    protected final boolean debug;
    protected Object sendMutex = new Object();
    private MessageListener messageListener;
    private final JMSSessionStatsImpl stats;
    private TransactionContext transactionContext;
    private DeliveryListener deliveryListener;
    private MessageTransformer transformer;
    private BlobTransferPolicy blobTransferPolicy;
    private long lastDeliveredSequenceId;

    protected BESMQSession(BESMQConnection connection, SessionId sessionId, int acknowledgeMode, boolean asyncDispatch, boolean sessionAsyncDispatch) throws JMSException {
        this.debug = LOG.isDebugEnabled();
        this.connection = connection;
        this.acknowledgementMode = acknowledgeMode;
        this.asyncDispatch = asyncDispatch;
        this.sessionAsyncDispatch = sessionAsyncDispatch;
        this.info = new SessionInfo(connection.getConnectionInfo(), sessionId.getValue());
        this.setTransactionContext(new TransactionContext(connection));
        this.stats = new JMSSessionStatsImpl(this.producers, this.consumers);
        this.connection.asyncSendPacket(this.info);
        this.setTransformer(connection.getTransformer());
        this.setBlobTransferPolicy(connection.getBlobTransferPolicy());
        this.connectionExecutor = connection.getExecutor();
        this.executor = new BESMQSessionExecutor(this);
        connection.addSession(this);
        if (connection.isStarted()) {
            this.start();
        }
    }

    protected BESMQSession(BESMQConnection connection, SessionId sessionId, int acknowledgeMode, boolean asyncDispatch) throws JMSException {
        this(connection, sessionId, acknowledgeMode, asyncDispatch, true);
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSSessionStatsImpl getSessionStats() {
        return this.stats;
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        BESMQBytesMessage message = new BESMQBytesMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        BESMQMapMessage message = new BESMQMapMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public Message createMessage() throws JMSException {
        BESMQMessage message = new BESMQMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        BESMQObjectMessage message = new BESMQObjectMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        BESMQObjectMessage message = new BESMQObjectMessage();
        this.configureMessage(message);
        message.setObject(object);
        return message;
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        BESMQStreamMessage message = new BESMQStreamMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        BESMQTextMessage message = new BESMQTextMessage();
        this.configureMessage(message);
        return message;
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        BESMQTextMessage message = new BESMQTextMessage();
        message.setText(text);
        this.configureMessage(message);
        return message;
    }

    public BlobMessage createBlobMessage(URL url) throws JMSException {
        return this.createBlobMessage(url, false);
    }

    public BlobMessage createBlobMessage(URL url, boolean deletedByBroker) throws JMSException {
        BESMQBlobMessage message = new BESMQBlobMessage();
        this.configureMessage(message);
        message.setURL(url);
        message.setDeletedByBroker(deletedByBroker);
        message.setBlobDownloader(new BlobDownloader(this.getBlobTransferPolicy()));
        return message;
    }

    public BlobMessage createBlobMessage(File file) throws JMSException {
        BESMQBlobMessage message = new BESMQBlobMessage();
        this.configureMessage(message);
        message.setBlobUploader(new BlobUploader(this.getBlobTransferPolicy(), file));
        message.setBlobDownloader(new BlobDownloader(this.getBlobTransferPolicy()));
        message.setDeletedByBroker(true);
        message.setName(file.getName());
        return message;
    }

    public BlobMessage createBlobMessage(InputStream in) throws JMSException {
        BESMQBlobMessage message = new BESMQBlobMessage();
        this.configureMessage(message);
        message.setBlobUploader(new BlobUploader(this.getBlobTransferPolicy(), in));
        message.setBlobDownloader(new BlobDownloader(this.getBlobTransferPolicy()));
        message.setDeletedByBroker(true);
        return message;
    }

    public FileMessage createFileMessage() throws JMSException {
        BESMQFileMessage message = new BESMQFileMessage();
        this.configureMessage(message);
        message.setBooleanProperty("BESMQ_FT_RETRANSFER_MODE", this.connection.getFileTransferPolicy().isResumeMode());
        message.setBooleanProperty("BESMQ_FT_REMOVE_SRC", this.connection.getFileTransferPolicy().isRemoveSrc());
        return message;
    }

    public FileMessage createFileMessage(String filePath) throws JMSException {
        BESMQFileMessage message = (BESMQFileMessage)this.createFileMessage();
        message.setFile(filePath);
        return message;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.isTransacted();
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgementMode;
    }

    @Override
    public void commit() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getSessionId() + " Transaction Commit :" + this.transactionContext.getTransactionId());
        }
        this.transactionContext.commit();
    }

    @Override
    public void rollback() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getSessionId() + " Transaction Rollback, txid:" + this.transactionContext.getTransactionId());
        }
        this.transactionContext.rollback();
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed) {
            if (this.getTransactionContext().isInXATransaction()) {
                if (!this.synchronizationRegistered) {
                    this.synchronizationRegistered = true;
                    this.getTransactionContext().addSynchronization(new Synchronization(){

                        public void afterCommit() throws Exception {
                            BESMQSession.this.doClose();
                            BESMQSession.this.synchronizationRegistered = false;
                        }

                        public void afterRollback() throws Exception {
                            BESMQSession.this.doClose();
                            BESMQSession.this.synchronizationRegistered = false;
                        }
                    });
                }
            } else {
                this.doClose();
            }
        }
    }

    private void doClose() throws JMSException {
        boolean interrupted = Thread.interrupted();
        this.dispose();
        RemoveInfo removeCommand = this.info.createRemoveCommand();
        removeCommand.setLastDeliveredSequenceId(this.lastDeliveredSequenceId);
        this.connection.asyncSendPacket(removeCommand);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    void clearMessagesInProgress() {
        this.executor.clearMessagesInProgress();
        for (final BESMQMessageConsumer consumer : this.consumers) {
            consumer.inProgressClearRequired();
            try {
                this.connection.getScheduler().executeAfterDelay(new Runnable(){

                    public void run() {
                        consumer.clearMessagesInProgress();
                    }
                }, 0L);
            }
            catch (JMSException e) {
                this.connection.onClientInternalException(e);
            }
        }
    }

    void deliverAcks() {
        for (BESMQMessageConsumer consumer : this.consumers) {
            consumer.deliverAcks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() throws JMSException {
        if (!this.closed) {
            try {
                this.executor.stop();
                for (BESMQMessageConsumer consumer : this.consumers) {
                    consumer.setFailureError(this.connection.getFirstFailureError());
                    consumer.dispose();
                    this.lastDeliveredSequenceId = Math.max(this.lastDeliveredSequenceId, consumer.getLastDeliveredSequenceId());
                }
                this.consumers.clear();
                for (BESMQMessageProducer producer : this.producers) {
                    producer.dispose();
                }
                this.producers.clear();
                try {
                    if (this.getTransactionContext().isInLocalTransaction()) {
                        this.rollback();
                    }
                }
                catch (JMSException jMSException) {
                }
                Object var4_4 = null;
                this.connection.removeSession(this);
                this.transactionContext = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.connection.removeSession(this);
                this.transactionContext = null;
                this.closed = true;
                throw throwable;
            }
        }
    }

    protected void configureMessage(BESMQMessage message) throws IllegalStateException {
        this.checkClosed();
        message.setConnection(this.connection);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Session is closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void recover() throws JMSException {
        this.checkClosed();
        if (this.getTransacted()) {
            throw new IllegalStateException("This session is transacted");
        }
        for (BESMQMessageConsumer c : this.consumers) {
            c.rollback();
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (listener != null) {
            this.checkClosed();
        }
        this.messageListener = listener;
        if (listener != null) {
            this.executor.setDispatchedBySessionPool(true);
        }
    }

    @Override
    public void run() {
        MessageDispatch messageDispatch;
        while ((messageDispatch = this.executor.dequeueNoWait()) != null) {
            final MessageDispatch md = messageDispatch;
            BESMQMessage message = (BESMQMessage)md.getMessage();
            if (message.isExpired() || this.connection.isDuplicate(this, message)) continue;
            if (this.isClientAcknowledge() || this.isIndividualAcknowledge()) {
                message.setAcknowledgeCallback(new Callback(){

                    public void execute() throws Exception {
                    }
                });
            }
            if (this.deliveryListener != null) {
                this.deliveryListener.beforeDelivery(this, message);
            }
            md.setDeliverySequenceId(this.getNextDeliveryId());
            try {
                this.messageListener.onMessage(message);
            }
            catch (RuntimeException e) {
                LOG.error("Error dispatching message: ", e);
                this.connection.onClientInternalException(e);
            }
            try {
                MessageAck ack = new MessageAck(md, 2, 1);
                ack.setFirstMessageId(md.getMessage().getMessageId());
                this.doStartTransaction();
                ack.setTransactionId(this.getTransactionContext().getTransactionId());
                if (ack.getTransactionId() != null) {
                    this.getTransactionContext().addSynchronization(new Synchronization(){

                        public void afterRollback() throws Exception {
                            md.getMessage().onMessageRolledBack();
                            BESMQSession.this.connection.rollbackDuplicate(BESMQSession.this, md.getMessage());
                            RedeliveryPolicy redeliveryPolicy = BESMQSession.this.connection.getRedeliveryPolicy();
                            int redeliveryCounter = md.getMessage().getRedeliveryCounter();
                            if (redeliveryPolicy.getMaximumRedeliveries() != -1 && redeliveryCounter > redeliveryPolicy.getMaximumRedeliveries()) {
                                MessageAck ack = new MessageAck(md, 1, 1);
                                ack.setFirstMessageId(md.getMessage().getMessageId());
                                ack.setPoisonCause(new Throwable("Exceeded RA's maximum redeliveries " + redeliveryPolicy.getMaximumRedeliveries()));
                                BESMQSession.this.asyncSendPacket(ack);
                            } else {
                                MessageAck ack = new MessageAck(md, 3, 1);
                                ack.setFirstMessageId(md.getMessage().getMessageId());
                                BESMQSession.this.asyncSendPacket(ack);
                                long redeliveryDelay = redeliveryPolicy.getInitialRedeliveryDelay();
                                for (int i = 0; i < redeliveryCounter; ++i) {
                                    redeliveryDelay = redeliveryPolicy.getNextRedeliveryDelay(redeliveryDelay);
                                }
                                BESMQSession.this.connection.getScheduler().executeAfterDelay(new Runnable(){

                                    public void run() {
                                        ((BESMQDispatcher)md.getConsumer()).dispatch(md);
                                    }
                                }, redeliveryDelay);
                            }
                        }
                    });
                }
                this.asyncSendPacket(ack);
            }
            catch (Throwable e) {
                this.connection.onClientInternalException(e);
            }
            if (this.deliveryListener == null) continue;
            this.deliveryListener.afterDelivery(this, message);
        }
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        if (destination instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)destination;
            return customDestination.createProducer(this);
        }
        int timeSendOut = this.connection.getSendTimeout();
        return new BESMQMessageProducer(this, this.getNextProducerId(), BESMQMessageTransformation.transformDestination(destination), timeSendOut);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, (String)null);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, MessageListener messageListener) throws JMSException {
        return this.createConsumer(destination, null, messageListener);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, MessageListener messageListener) throws JMSException {
        return this.createConsumer(destination, messageSelector, false, messageListener);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.createConsumer(destination, messageSelector, noLocal, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal, MessageListener messageListener) throws JMSException {
        this.checkClosed();
        if (destination instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)destination;
            return customDestination.createConsumer(this, messageSelector, noLocal);
        }
        BESMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        int prefetch = 0;
        prefetch = destination instanceof Topic ? prefetchPolicy.getTopicPrefetch() : prefetchPolicy.getQueuePrefetch();
        BESMQDestination besmqDestination = BESMQMessageTransformation.transformDestination(destination);
        return new BESMQMessageConsumer(this, this.getNextConsumerId(), besmqDestination, null, messageSelector, prefetch, prefetchPolicy.getMaximumPendingMessageLimit(), noLocal, false, this.isAsyncDispatch(), messageListener);
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        if (queueName.startsWith("ID:")) {
            return new BESMQTempQueue(queueName);
        }
        return new BESMQQueue(queueName);
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        if (topicName.startsWith("ID:")) {
            return new BESMQTempTopic(topicName);
        }
        return new BESMQTopic(topicName);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (this.isIndividualAcknowledge()) {
            throw JMSExceptionSupport.create("Cannot create a durable consumer for a Session in INDIVIDUAL_ACKNOWLEDGE mode.", null);
        }
        if (topic == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createDurableSubscriber(this, name, messageSelector, noLocal);
        }
        this.connection.checkClientIDWasManuallySpecified();
        BESMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        int prefetch = this.isAutoAcknowledge() && this.connection.isOptimizedMessageDispatch() ? prefetchPolicy.getOptimizeDurableTopicPrefetch() : prefetchPolicy.getDurableTopicPrefetch();
        int maxPrendingLimit = prefetchPolicy.getMaximumPendingMessageLimit();
        return new BESMQTopicSubscriber(this, this.getNextConsumerId(), BESMQMessageTransformation.transformDestination(topic), name, messageSelector, prefetch, maxPrendingLimit, noLocal, false, this.asyncDispatch);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createBrowser(queue, null);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        return new BESMQQueueBrowser(this, this.getNextConsumerId(), BESMQMessageTransformation.transformDestination(queue), messageSelector, this.asyncDispatch);
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        return (TemporaryQueue)((Object)this.connection.createTempDestination(false));
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        return (TemporaryTopic)((Object)this.connection.createTempDestination(true));
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createReceiver(queue, null);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        if (queue instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)queue);
            return customDestination.createReceiver(this, messageSelector);
        }
        BESMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        return new BESMQQueueReceiver(this, this.getNextConsumerId(), BESMQMessageTransformation.transformDestination(queue), messageSelector, prefetchPolicy.getQueuePrefetch(), prefetchPolicy.getMaximumPendingMessageLimit(), this.asyncDispatch);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        if (queue instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)queue);
            return customDestination.createSender(this);
        }
        int timeSendOut = this.connection.getSendTimeout();
        return new BESMQQueueSender(this, BESMQMessageTransformation.transformDestination(queue), timeSendOut);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        return this.createSubscriber(topic, null, false);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createSubscriber(this, messageSelector, noLocal);
        }
        BESMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        return new BESMQTopicSubscriber(this, this.getNextConsumerId(), BESMQMessageTransformation.transformDestination(topic), null, messageSelector, prefetchPolicy.getTopicPrefetch(), prefetchPolicy.getMaximumPendingMessageLimit(), noLocal, false, this.asyncDispatch);
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createPublisher(this);
        }
        int timeSendOut = this.connection.getSendTimeout();
        return new BESMQTopicPublisher(this, BESMQMessageTransformation.transformDestination(topic), timeSendOut);
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        this.connection.unsubscribe(name);
    }

    @Override
    public void dispatch(MessageDispatch messageDispatch) {
        try {
            this.executor.execute(messageDispatch);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.connection.onClientInternalException(e);
        }
    }

    public void acknowledge() throws JMSException {
        for (BESMQMessageConsumer c : this.consumers) {
            c.acknowledge();
        }
    }

    protected void addConsumer(BESMQMessageConsumer consumer) throws JMSException {
        this.consumers.add(consumer);
        if (consumer.isDurableSubscriber()) {
            this.stats.onCreateDurableSubscriber();
        }
        this.connection.addDispatcher(consumer.getConsumerId(), this);
    }

    protected void removeConsumer(BESMQMessageConsumer consumer) {
        this.connection.removeDispatcher(consumer.getConsumerId());
        if (consumer.isDurableSubscriber()) {
            this.stats.onRemoveDurableSubscriber();
        }
        this.consumers.remove(consumer);
        this.connection.removeDispatcher(consumer);
    }

    protected void addProducer(BESMQMessageProducer producer) throws JMSException {
        this.producers.add(producer);
        this.connection.addProducer(producer.getProducerInfo().getProducerId(), producer);
    }

    protected void removeProducer(BESMQMessageProducer producer) {
        this.connection.removeProducer(producer.getProducerInfo().getProducerId());
        this.producers.remove(producer);
    }

    protected void start() throws JMSException {
        this.started.set(true);
        for (BESMQMessageConsumer c : this.consumers) {
            c.start();
        }
        this.executor.start();
    }

    protected void stop() throws JMSException {
        for (BESMQMessageConsumer c : this.consumers) {
            c.stop();
        }
        this.started.set(false);
        this.executor.stop();
    }

    protected SessionId getSessionId() {
        return this.info.getSessionId();
    }

    protected ConsumerId getNextConsumerId() {
        return new ConsumerId(this.info.getSessionId(), this.consumerIdGenerator.getNextSequenceId());
    }

    protected ProducerId getNextProducerId() {
        return new ProducerId(this.info.getSessionId(), this.producerIdGenerator.getNextSequenceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(BESMQMessageProducer producer, BESMQDestination destination, Message message, int deliveryMode, int priority, long timeToLive, MemoryUsage producerWindow, int sendTimeout, AsyncCallback onComplete) throws JMSException {
        this.checkClosed();
        if (destination.isTemporary() && this.connection.isDeleted(destination)) {
            throw new InvalidDestinationException("Cannot publish to a deleted Destination: " + destination);
        }
        Object object = this.sendMutex;
        synchronized (object) {
            boolean syncSend;
            this.doStartTransaction();
            TransactionId txid = this.transactionContext.getTransactionId();
            long sequenceNumber = producer.getMessageSequence();
            if (deliveryMode != 2 && deliveryMode != 1) {
                throw new IllegalStateException("unknown delivery mode: " + deliveryMode);
            }
            message.setJMSDeliveryMode(deliveryMode);
            long expiration = 0L;
            if (!producer.getDisableMessageTimestamp()) {
                long timeStamp = System.currentTimeMillis();
                message.setJMSTimestamp(timeStamp);
                if (timeToLive > 0L) {
                    expiration = timeToLive + timeStamp;
                }
            }
            message.setJMSExpiration(expiration);
            if (priority < 0 || priority > 9) {
                throw new IllegalStateException("default priority must be a value between 0 and 9");
            }
            message.setJMSPriority(priority);
            message.setJMSRedelivered(false);
            BESMQMessage msg = BESMQMessageTransformation.transformMessage(message, this.connection);
            if (msg == message) {
                msg.setMessageId(new MessageId(producer.getProducerInfo().getProducerId(), sequenceNumber));
            } else {
                msg.setMessageId(new MessageId(producer.getProducerInfo().getProducerId(), sequenceNumber));
                message.setJMSMessageID(msg.getMessageId().toString());
            }
            msg.setBrokerPath(null);
            msg.setJMSDestination(destination);
            msg.setTransactionId(txid);
            if (this.connection.isCopyMessageOnSend()) {
                msg = (BESMQMessage)msg.copy();
            }
            msg.setMessageProducer(producer);
            msg.setConnection(this.connection);
            msg.setProducerId(msg.getMessageId().getProducerId());
            msg.onSend();
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.getSessionId() + " sending message: " + msg);
            }
            boolean bl = syncSend = msg.isPersistent() ? this.connection.isSyncSendPersistentMessage() : this.connection.isSyncSendNonPersistentMessage();
            if (onComplete == null && sendTimeout <= 0 && !msg.isResponseRequired() && !syncSend) {
                this.connection.asyncSendPacket(msg);
                if (producerWindow != null) {
                    int size = msg.getSize();
                    producerWindow.increaseUsage(size);
                }
            } else if (sendTimeout > 0 && onComplete == null) {
                this.connection.syncSendPacket((Command)msg, sendTimeout);
            } else if (onComplete == BESMQMessageProducer.ONEWAY_CB) {
                this.connection.onewaySendPacket(msg);
                if (producerWindow != null) {
                    int size = msg.getSize();
                    producerWindow.increaseUsage(size);
                }
            } else {
                this.connection.syncSendPacket((Command)msg, onComplete);
            }
        }
    }

    protected void doStartTransaction() throws JMSException {
        if (this.getTransacted() && !this.transactionContext.isInXATransaction()) {
            this.transactionContext.begin();
        }
    }

    public boolean hasUncomsumedMessages() {
        return this.executor.hasUncomsumedMessages();
    }

    public boolean isTransacted() {
        return this.acknowledgementMode == 0 || this.transactionContext.isInXATransaction();
    }

    protected boolean isClientAcknowledge() {
        return this.acknowledgementMode == 2;
    }

    public boolean isAutoAcknowledge() {
        return this.acknowledgementMode == 1;
    }

    public boolean isDupsOkAcknowledge() {
        return this.acknowledgementMode == 3;
    }

    public boolean isIndividualAcknowledge() {
        return this.acknowledgementMode == 4;
    }

    public DeliveryListener getDeliveryListener() {
        return this.deliveryListener;
    }

    public void setDeliveryListener(DeliveryListener deliveryListener) {
        this.deliveryListener = deliveryListener;
    }

    protected SessionInfo getSessionInfo() throws JMSException {
        SessionInfo info = new SessionInfo(this.connection.getConnectionInfo(), this.getSessionId().getValue());
        return info;
    }

    public void asyncSendPacket(Command command) throws JMSException {
        this.connection.asyncSendPacket(command);
    }

    public Response syncSendPacket(Command command) throws JMSException {
        return this.connection.syncSendPacket(command);
    }

    public long getNextDeliveryId() {
        return this.deliveryIdGenerator.getNextSequenceId();
    }

    public void redispatch(BESMQDispatcher dispatcher, MessageDispatchChannel unconsumedMessages) throws JMSException {
        List<MessageDispatch> c = unconsumedMessages.removeAll();
        for (MessageDispatch md : c) {
            this.connection.rollbackDuplicate(dispatcher, md.getMessage());
        }
        Collections.reverse(c);
        for (MessageDispatch md : c) {
            this.executor.executeFirst(md);
        }
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public boolean isAsyncDispatch() {
        return this.asyncDispatch;
    }

    public void setAsyncDispatch(boolean asyncDispatch) {
        this.asyncDispatch = asyncDispatch;
    }

    public boolean isSessionAsyncDispatch() {
        return this.sessionAsyncDispatch;
    }

    public void setSessionAsyncDispatch(boolean sessionAsyncDispatch) {
        this.sessionAsyncDispatch = sessionAsyncDispatch;
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public BESMQConnection getConnection() {
        return this.connection;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public void setBlobTransferPolicy(BlobTransferPolicy blobTransferPolicy) {
        this.blobTransferPolicy = blobTransferPolicy;
    }

    public List<MessageDispatch> getUnconsumedMessages() {
        return this.executor.getUnconsumedMessages();
    }

    public String toString() {
        return "BESMQSession {id=" + this.info.getSessionId() + ",started=" + this.started.get() + "}";
    }

    public void checkMessageListener() throws JMSException {
        if (this.messageListener != null) {
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
        for (BESMQMessageConsumer consumer : this.consumers) {
            if (consumer.getMessageListener() == null) continue;
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
    }

    protected void setOptimizeAcknowledge(boolean value) {
        for (BESMQMessageConsumer c : this.consumers) {
            c.setOptimizeAcknowledge(value);
        }
    }

    protected void setPrefetchSize(ConsumerId id, int prefetch) {
        for (BESMQMessageConsumer c : this.consumers) {
            if (!c.getConsumerId().equals(id)) continue;
            c.setPrefetchSize(prefetch);
            break;
        }
    }

    protected void close(ConsumerId id) {
        for (BESMQMessageConsumer c : this.consumers) {
            if (!c.getConsumerId().equals(id)) continue;
            try {
                c.close();
            }
            catch (JMSException e) {
                LOG.warn("Exception closing consumer", e);
            }
            LOG.warn("Closed consumer on Command");
            break;
        }
    }

    public boolean isInUse(BESMQTempDestination destination) {
        for (BESMQMessageConsumer c : this.consumers) {
            if (!c.isInUse(destination)) continue;
            return true;
        }
        return false;
    }

    public long getLastDeliveredSequenceId() {
        return this.lastDeliveredSequenceId;
    }

    public BESMQMessageConsumer getConsumer(ConsumerId id) {
        for (BESMQMessageConsumer c : this.consumers) {
            if (!c.getConsumerId().equals(id)) continue;
            return c;
        }
        return null;
    }

    protected void sendAck(MessageAck ack) throws JMSException {
        this.sendAck(ack, false);
    }

    protected void sendAck(MessageAck ack, boolean lazy) throws JMSException {
        if (lazy || this.connection.isSendAcksAsync() || this.getTransacted()) {
            this.asyncSendPacket(ack);
        } else {
            this.syncSendPacket(ack);
        }
    }

    protected Scheduler getScheduler() throws JMSException {
        return this.connection.getScheduler();
    }

    protected ThreadPoolExecutor getConnectionExecutor() {
        return this.connectionExecutor;
    }

    public static interface DeliveryListener {
        public void beforeDelivery(BESMQSession var1, Message var2);

        public void afterDelivery(BESMQSession var1, Message var2);
    }
}

