/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.enterprise.gmssl.GMKeyStore;
import com.bes.mq.BESMQConnectionFactory;
import com.bes.mq.Utils;
import com.bes.mq.broker.JSSEKeyManager;
import com.bes.mq.broker.SslContext;
import com.bes.mq.transport.Transport;
import com.bes.mq.util.JMSExceptionSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.jms.JMSException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class BESMQSslConnectionFactory
extends BESMQConnectionFactory {
    protected String protocol = "TLS";
    protected String secureRandomAlgorithm = "SHA1PRNG";
    protected String keyStoreType = "jks";
    protected String trustStoreType = "jks";
    protected KeyManager[] keyManager;
    protected TrustManager[] trustManager;
    protected SecureRandom secureRandom;
    protected String trustStore;
    protected String trustStorePassword;
    protected String keyStore;
    protected String keyStorePassword;
    protected String keyStoreKeyPassword;
    protected String certNickName;

    public BESMQSslConnectionFactory() {
    }

    public BESMQSslConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public BESMQSslConnectionFactory(URI brokerURL) {
        super(brokerURL);
    }

    public void setKeyAndTrustManagers(KeyManager[] km, TrustManager[] tm, SecureRandom random) {
        this.keyManager = km;
        this.trustManager = tm;
        this.secureRandom = random;
    }

    protected Transport createTransport() throws JMSException {
        SslContext existing = SslContext.getCurrentSslContext();
        try {
            Object context;
            if (this.keyStore != null || this.trustStore != null) {
                this.keyManager = this.createKeyManager();
                this.trustManager = this.createTrustManager();
            }
            if (this.secureRandom == null) {
                this.secureRandom = this.createSecureRandom();
            }
            if (this.keyManager != null || this.trustManager != null) {
                context = new SslContext(this.keyManager, this.trustManager, this.secureRandom);
                ((SslContext)context).setKeyAlias(this.certNickName);
                ((SslContext)context).setProtocol(this.protocol);
                ((SslContext)context).setSecureRandom(this.secureRandom);
                SslContext.setCurrentSslContext((SslContext)context);
            }
            context = super.createTransport();
            return context;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Could not create Transport. Reason: " + e, e);
        }
        finally {
            SslContext.setCurrentSslContext(existing);
        }
    }

    protected TrustManager[] createTrustManager() throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = null;
        trustedCertStore = "bks".equalsIgnoreCase(this.trustStoreType) ? GMKeyStore.getInstance() : KeyStore.getInstance(this.trustStoreType);
        if (this.trustStore != null) {
            InputStream tsStream = this.getUrlOrResourceAsStream(this.trustStore);
            trustedCertStore.load(tsStream, this.trustStorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustedCertStore);
            trustStoreManagers = tmf.getTrustManagers();
        }
        return trustStoreManagers;
    }

    protected KeyManager[] createKeyManager() throws Exception {
        byte[] sslCert;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = null;
        ks = "bks".equalsIgnoreCase(this.keyStoreType) ? GMKeyStore.getInstance() : KeyStore.getInstance(this.keyStoreType);
        KeyManager[] keystoreManagers = null;
        if (this.keyStore != null && (sslCert = this.loadClientCredential(this.keyStore)) != null && sslCert.length > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
            ks.load(bin, !this.isOk(this.keyStorePassword) ? null : this.keyStorePassword.toCharArray());
            kmf.init(ks, !this.isOk(this.keyStoreKeyPassword) ? null : this.keyStoreKeyPassword.toCharArray());
            keystoreManagers = kmf.getKeyManagers();
        }
        if (keystoreManagers != null && "bks".equalsIgnoreCase(this.keyStoreType)) {
            String alias = this.certNickName;
            if ("JKS".equalsIgnoreCase(this.keyStoreType)) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < keystoreManagers.length; ++i) {
                keystoreManagers[i] = new JSSEKeyManager((X509KeyManager)keystoreManagers[i], alias);
            }
        }
        return keystoreManagers;
    }

    protected byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        InputStream in = this.getUrlOrResourceAsStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    protected InputStream getUrlOrResourceAsStream(String urlOrResource) throws IOException {
        return Utils.tryGetInputStream(urlOrResource);
    }

    private SecureRandom createSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(this.secureRandomAlgorithm);
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) throws Exception {
        this.trustStore = trustStore;
        this.trustManager = null;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) throws Exception {
        this.keyStore = keyStore;
        this.keyManager = null;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getCertNickName() {
        return this.certNickName;
    }

    public void setCertNickName(String certNickName) {
        this.certNickName = certNickName;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    private boolean isOk(String s) {
        return s != null && s.length() > 0;
    }
}

