/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQQueueSession;
import com.bes.mq.BESMQSession;
import com.bes.mq.BESMQTopicSession;
import com.bes.mq.BESMQXAConnection;
import com.bes.mq.command.SessionId;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;

public class BESMQXASession
extends BESMQSession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    public BESMQXASession(BESMQXAConnection connection, SessionId sessionId, int theAcknowlegeMode, boolean dispatchAsync) throws JMSException {
        super(connection, sessionId, theAcknowlegeMode, dispatchAsync);
    }

    public boolean getTransacted() throws JMSException {
        return this.getTransactionContext().isInXATransaction();
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Cannot rollback() inside an XASession");
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("Cannot commit() inside an XASession");
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this.getTransactionContext();
    }

    public QueueSession getQueueSession() throws JMSException {
        return new BESMQQueueSession(this);
    }

    public TopicSession getTopicSession() throws JMSException {
        return new BESMQTopicSession(this);
    }

    public boolean isAutoAcknowledge() {
        return true;
    }

    protected void doStartTransaction() throws JMSException {
    }
}

