/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQDispatcher;
import com.bes.mq.BESMQMessageAudit;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.Message;
import com.bes.mq.util.LRUCache;
import java.util.LinkedHashMap;

class ConnectionAudit {
    private boolean checkForDuplicates;
    private LinkedHashMap<BESMQDestination, BESMQMessageAudit> destinations = new LRUCache<BESMQDestination, BESMQMessageAudit>(1000);
    private LinkedHashMap<BESMQDispatcher, BESMQMessageAudit> dispatchers = new LRUCache<BESMQDispatcher, BESMQMessageAudit>(1000);
    private int auditDepth = 2048;
    private int auditMaximumProducerNumber = 64;

    ConnectionAudit() {
    }

    synchronized void removeDispatcher(BESMQDispatcher dispatcher) {
        this.dispatchers.remove(dispatcher);
    }

    synchronized boolean isDuplicate(BESMQDispatcher dispatcher, Message message) {
        BESMQDestination destination;
        if (this.checkForDuplicates && message != null && (destination = message.getDestination()) != null) {
            if (destination.isQueue()) {
                BESMQMessageAudit audit = this.destinations.get(destination);
                if (audit == null) {
                    audit = new BESMQMessageAudit(this.auditDepth, this.auditMaximumProducerNumber);
                    this.destinations.put(destination, audit);
                }
                boolean result = audit.isDuplicate(message);
                return result;
            }
            BESMQMessageAudit audit = this.dispatchers.get(dispatcher);
            if (audit == null) {
                audit = new BESMQMessageAudit(this.auditDepth, this.auditMaximumProducerNumber);
                this.dispatchers.put(dispatcher, audit);
            }
            boolean result = audit.isDuplicate(message);
            return result;
        }
        return false;
    }

    protected synchronized void rollbackDuplicate(BESMQDispatcher dispatcher, Message message) {
        BESMQDestination destination;
        if (this.checkForDuplicates && message != null && (destination = message.getDestination()) != null) {
            if (destination.isQueue()) {
                BESMQMessageAudit audit = this.destinations.get(destination);
                if (audit != null) {
                    audit.rollback(message);
                }
            } else {
                BESMQMessageAudit audit = this.dispatchers.get(dispatcher);
                if (audit != null) {
                    audit.rollback(message);
                }
            }
        }
    }

    boolean isCheckForDuplicates() {
        return this.checkForDuplicates;
    }

    void setCheckForDuplicates(boolean checkForDuplicates) {
        this.checkForDuplicates = checkForDuplicates;
    }

    public int getAuditDepth() {
        return this.auditDepth;
    }

    public void setAuditDepth(int auditDepth) {
        this.auditDepth = auditDepth;
    }

    public int getAuditMaximumProducerNumber() {
        return this.auditMaximumProducerNumber;
    }

    public void setAuditMaximumProducerNumber(int auditMaximumProducerNumber) {
        this.auditMaximumProducerNumber = auditMaximumProducerNumber;
    }
}

