/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq;

import com.bes.mq.BESMQConnection;
import com.bes.mq.BESMQDispatcher;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BESMQTempDestination;
import com.bes.mq.command.ConsumerId;
import com.bes.mq.command.ConsumerInfo;
import com.bes.mq.command.DataStructure;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.MessageAck;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.notification.NotificationSupport;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import javax.jms.JMSException;

public class NotificationConsumer
implements BESMQDispatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(NotificationConsumer.class);
    int deliveredCounter;
    private final BESMQConnection connection;
    private ConsumerInfo info;
    private boolean closed;

    public NotificationConsumer(BESMQConnection connection, ConsumerId consumerId) throws JMSException {
        this.connection = connection;
        this.info = new ConsumerInfo(consumerId);
        this.info.setDestination(NotificationSupport.TEMP_DESTINATION_COMPOSITE_NOTIFICATION_TOPIC);
        this.info.setPrefetchSize(1000);
        this.info.setNoLocal(true);
        this.info.setDispatchAsync(true);
        this.connection.addDispatcher(this.info.getConsumerId(), this);
        this.connection.syncSendPacket(this.info);
    }

    public synchronized void dispose() {
        if (!this.closed) {
            try {
                this.connection.asyncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                LOG.debug("Failed to send remove command: " + e, e);
            }
            this.connection.removeDispatcher(this.info.getConsumerId());
            this.closed = true;
        }
    }

    public void dispatch(MessageDispatch md) {
        DataStructure o;
        ++this.deliveredCounter;
        if ((double)this.deliveredCounter > 0.75 * (double)this.info.getPrefetchSize()) {
            try {
                MessageAck ack = new MessageAck(md, 2, this.deliveredCounter);
                this.connection.asyncSendPacket(ack);
                this.deliveredCounter = 0;
            }
            catch (JMSException e) {
                this.connection.onClientInternalException(e);
            }
        }
        if ((o = md.getMessage().getDataStructure()) != null && o.getClass() == DestinationInfo.class) {
            this.processDestinationInfo((DestinationInfo)o);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Unexpected message was dispatched to the NotificationConsumer: " + md);
        }
    }

    private void processDestinationInfo(DestinationInfo dinfo) {
        BESMQDestination dest = dinfo.getDestination();
        if (!dest.isTemporary()) {
            return;
        }
        BESMQTempDestination tempDest = (BESMQTempDestination)dest;
        if (dinfo.getOperationType() == 0) {
            if (tempDest.getConnection() != null) {
                tempDest = (BESMQTempDestination)tempDest.createDestination(tempDest.getPhysicalName());
            }
            this.connection.activeTempDestinations.put(tempDest, tempDest);
        } else if (dinfo.getOperationType() == 1) {
            this.connection.activeTempDestinations.remove(tempDest);
        }
    }
}

