/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.besmp.v1;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.besmp.BooleanStream;
import com.bes.mq.besmp.DataStreamMarshaller;
import com.bes.mq.command.DataStructure;
import com.bes.mq.util.ByteSequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;

public abstract class BaseDataStreamMarshaller
implements DataStreamMarshaller {
    public static final Constructor STACK_TRACE_ELEMENT_CONSTRUCTOR;

    public abstract byte getDataStructureType();

    public abstract DataStructure createObject();

    public int tightMarshal1(BESMPFormat protocolFormat, Object o, BooleanStream bs) throws IOException {
        return 0;
    }

    public void tightMarshal2(BESMPFormat protocolFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
    }

    public void tightUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
    }

    public int tightMarshalLong1(BESMPFormat protocolFormat, long o, BooleanStream bs) throws IOException {
        if (o == 0L) {
            bs.writeBoolean(false);
            bs.writeBoolean(false);
            return 0;
        }
        if ((o & 0xFFFFFFFFFFFF0000L) == 0L) {
            bs.writeBoolean(false);
            bs.writeBoolean(true);
            return 2;
        }
        if ((o & 0xFFFFFFFF00000000L) == 0L) {
            bs.writeBoolean(true);
            bs.writeBoolean(false);
            return 4;
        }
        bs.writeBoolean(true);
        bs.writeBoolean(true);
        return 8;
    }

    public void tightMarshalLong2(BESMPFormat protocolFormat, long o, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                dataOut.writeLong(o);
            } else {
                dataOut.writeInt((int)o);
            }
        } else if (bs.readBoolean()) {
            dataOut.writeShort((int)o);
        }
    }

    public long tightUnmarshalLong(BESMPFormat protocolFormat, DataInput dataIn, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                return dataIn.readLong();
            }
            return this.toLong(dataIn.readInt());
        }
        if (bs.readBoolean()) {
            return this.toLong(dataIn.readShort());
        }
        return 0L;
    }

    protected long toLong(short value) {
        long answer = value;
        return answer & 0xFFFFL;
    }

    protected long toLong(int value) {
        long answer = value;
        return answer & 0xFFFFFFFFL;
    }

    protected DataStructure tightUnmarsalNestedObject(BESMPFormat protocolFormat, DataInput dataIn, BooleanStream bs) throws IOException {
        return protocolFormat.tightUnmarshalNestedObject(dataIn, bs);
    }

    protected int tightMarshalNestedObject1(BESMPFormat protocolFormat, DataStructure o, BooleanStream bs) throws IOException {
        return protocolFormat.tightMarshalNestedObject1(o, bs);
    }

    protected void tightMarshalNestedObject2(BESMPFormat protocolFormat, DataStructure o, DataOutput dataOut, BooleanStream bs) throws IOException {
        protocolFormat.tightMarshalNestedObject2(o, dataOut, bs);
    }

    protected DataStructure tightUnmarsalCachedObject(BESMPFormat protocolFormat, DataInput dataIn, BooleanStream bs) throws IOException {
        if (protocolFormat.isCacheEnabled()) {
            if (bs.readBoolean()) {
                short index = dataIn.readShort();
                DataStructure object = protocolFormat.tightUnmarshalNestedObject(dataIn, bs);
                protocolFormat.setInUnmarshallCache(index, object);
                return object;
            }
            short index = dataIn.readShort();
            return protocolFormat.getFromUnmarshallCache(index);
        }
        return protocolFormat.tightUnmarshalNestedObject(dataIn, bs);
    }

    protected int tightMarshalCachedObject1(BESMPFormat protocolFormat, DataStructure o, BooleanStream bs) throws IOException {
        if (protocolFormat.isCacheEnabled()) {
            Short index = protocolFormat.getMarshallCacheIndex(o);
            bs.writeBoolean(index == null);
            if (index == null) {
                int rc = protocolFormat.tightMarshalNestedObject1(o, bs);
                protocolFormat.addToMarshallCache(o);
                return 2 + rc;
            }
            return 2;
        }
        return protocolFormat.tightMarshalNestedObject1(o, bs);
    }

    protected void tightMarshalCachedObject2(BESMPFormat protocolFormat, DataStructure o, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (protocolFormat.isCacheEnabled()) {
            Short index = protocolFormat.getMarshallCacheIndex(o);
            if (bs.readBoolean()) {
                dataOut.writeShort(index.shortValue());
                protocolFormat.tightMarshalNestedObject2(o, dataOut, bs);
            } else {
                dataOut.writeShort(index.shortValue());
            }
        } else {
            protocolFormat.tightMarshalNestedObject2(o, dataOut, bs);
        }
    }

    protected Throwable tightUnmarsalThrowable(BESMPFormat protocolFormat, DataInput dataIn, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            String clazz = this.tightUnmarshalString(dataIn, bs);
            String message = this.tightUnmarshalString(dataIn, bs);
            Throwable o = this.createThrowable(clazz, message);
            if (protocolFormat.isStackTraceEnabled()) {
                if (STACK_TRACE_ELEMENT_CONSTRUCTOR != null) {
                    StackTraceElement[] ss = new StackTraceElement[dataIn.readShort()];
                    for (int i = 0; i < ss.length; ++i) {
                        try {
                            ss[i] = (StackTraceElement)STACK_TRACE_ELEMENT_CONSTRUCTOR.newInstance(this.tightUnmarshalString(dataIn, bs), this.tightUnmarshalString(dataIn, bs), this.tightUnmarshalString(dataIn, bs), dataIn.readInt());
                            continue;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    o.setStackTrace(ss);
                } else {
                    int size = dataIn.readShort();
                    for (int i = 0; i < size; ++i) {
                        this.tightUnmarshalString(dataIn, bs);
                        this.tightUnmarshalString(dataIn, bs);
                        this.tightUnmarshalString(dataIn, bs);
                        dataIn.readInt();
                    }
                }
                o.initCause(this.tightUnmarsalThrowable(protocolFormat, dataIn, bs));
            }
            return o;
        }
        return null;
    }

    private Throwable createThrowable(String className, String message) {
        try {
            Class<?> clazz = Class.forName(className, false, BaseDataStreamMarshaller.class.getClassLoader());
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (Throwable)constructor.newInstance(message);
        }
        catch (Throwable e) {
            return new Throwable(className + ": " + message);
        }
    }

    protected int tightMarshalThrowable1(BESMPFormat protocolFormat, Throwable o, BooleanStream bs) throws IOException {
        if (o == null) {
            bs.writeBoolean(false);
            return 0;
        }
        int rc = 0;
        bs.writeBoolean(true);
        rc += this.tightMarshalString1(o.getClass().getName(), bs);
        rc += this.tightMarshalString1(o.getMessage(), bs);
        if (protocolFormat.isStackTraceEnabled()) {
            rc += 2;
            StackTraceElement[] stackTrace = o.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                rc += this.tightMarshalString1(element.getClassName(), bs);
                rc += this.tightMarshalString1(element.getMethodName(), bs);
                rc += this.tightMarshalString1(element.getFileName(), bs);
                rc += 4;
            }
            rc += this.tightMarshalThrowable1(protocolFormat, o.getCause(), bs);
        }
        return rc;
    }

    protected void tightMarshalThrowable2(BESMPFormat protocolFormat, Throwable o, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            this.tightMarshalString2(o.getClass().getName(), dataOut, bs);
            this.tightMarshalString2(o.getMessage(), dataOut, bs);
            if (protocolFormat.isStackTraceEnabled()) {
                StackTraceElement[] stackTrace = o.getStackTrace();
                dataOut.writeShort(stackTrace.length);
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement element = stackTrace[i];
                    this.tightMarshalString2(element.getClassName(), dataOut, bs);
                    this.tightMarshalString2(element.getMethodName(), dataOut, bs);
                    this.tightMarshalString2(element.getFileName(), dataOut, bs);
                    dataOut.writeInt(element.getLineNumber());
                }
                this.tightMarshalThrowable2(protocolFormat, o.getCause(), dataOut, bs);
            }
        }
    }

    protected String tightUnmarshalString(DataInput dataIn, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                short size = dataIn.readShort();
                byte[] data = new byte[size];
                dataIn.readFully(data);
                return new String(data, 0);
            }
            return dataIn.readUTF();
        }
        return null;
    }

    protected int tightMarshalString1(String value, BooleanStream bs) throws IOException {
        bs.writeBoolean(value != null);
        if (value != null) {
            int strlen = value.length();
            int utflen = 0;
            char[] charr = new char[strlen];
            char c = '\u0000';
            boolean isOnlyAscii = true;
            value.getChars(0, strlen, charr, 0);
            for (int i = 0; i < strlen; ++i) {
                c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    isOnlyAscii = false;
                    continue;
                }
                isOnlyAscii = false;
                utflen += 2;
            }
            if (utflen >= Short.MAX_VALUE) {
                throw new IOException("Encountered a String value that is too long to encode.");
            }
            bs.writeBoolean(isOnlyAscii);
            return utflen + 2;
        }
        return 0;
    }

    protected void tightMarshalString2(String value, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            if (bs.readBoolean()) {
                dataOut.writeShort(value.length());
                dataOut.writeBytes(value);
            } else {
                dataOut.writeUTF(value);
            }
        }
    }

    protected int tightMarshalObjectArray1(BESMPFormat protocolFormat, DataStructure[] objects, BooleanStream bs) throws IOException {
        if (objects != null) {
            int rc = 0;
            bs.writeBoolean(true);
            rc += 2;
            for (int i = 0; i < objects.length; ++i) {
                rc += this.tightMarshalNestedObject1(protocolFormat, objects[i], bs);
            }
            return rc;
        }
        bs.writeBoolean(false);
        return 0;
    }

    protected void tightMarshalObjectArray2(BESMPFormat protocolFormat, DataStructure[] objects, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            dataOut.writeShort(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                this.tightMarshalNestedObject2(protocolFormat, objects[i], dataOut, bs);
            }
        }
    }

    protected int tightMarshalConstByteArray1(byte[] data, BooleanStream bs, int i) throws IOException {
        return i;
    }

    protected void tightMarshalConstByteArray2(byte[] data, DataOutput dataOut, BooleanStream bs, int i) throws IOException {
        dataOut.write(data, 0, i);
    }

    protected byte[] tightUnmarshalConstByteArray(DataInput dataIn, BooleanStream bs, int i) throws IOException {
        byte[] data = new byte[i];
        dataIn.readFully(data);
        return data;
    }

    protected int tightMarshalByteArray1(byte[] data, BooleanStream bs) throws IOException {
        bs.writeBoolean(data != null);
        if (data != null) {
            return data.length + 4;
        }
        return 0;
    }

    protected void tightMarshalByteArray2(byte[] data, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }
    }

    protected byte[] tightUnmarshalByteArray(DataInput dataIn, BooleanStream bs) throws IOException {
        byte[] rc = null;
        if (bs.readBoolean()) {
            int size = dataIn.readInt();
            rc = new byte[size];
            dataIn.readFully(rc);
        }
        return rc;
    }

    protected int tightMarshalByteSequence1(ByteSequence data, BooleanStream bs) throws IOException {
        bs.writeBoolean(data != null);
        if (data != null) {
            return data.getLength() + 4;
        }
        return 0;
    }

    protected void tightMarshalByteSequence2(ByteSequence data, DataOutput dataOut, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            dataOut.writeInt(data.getLength());
            dataOut.write(data.getData(), data.getOffset(), data.getLength());
        }
    }

    protected ByteSequence tightUnmarshalByteSequence(DataInput dataIn, BooleanStream bs) throws IOException {
        ByteSequence rc = null;
        if (bs.readBoolean()) {
            int size = dataIn.readInt();
            byte[] t = new byte[size];
            dataIn.readFully(t);
            return new ByteSequence(t, 0, size);
        }
        return rc;
    }

    public void looseMarshal(BESMPFormat protocolFormat, Object o, DataOutput dataOut) throws IOException {
    }

    public void looseUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn) throws IOException {
    }

    public void looseMarshalLong(BESMPFormat protocolFormat, long o, DataOutput dataOut) throws IOException {
        dataOut.writeLong(o);
    }

    public long looseUnmarshalLong(BESMPFormat protocolFormat, DataInput dataIn) throws IOException {
        return dataIn.readLong();
    }

    protected DataStructure looseUnmarsalNestedObject(BESMPFormat protocolFormat, DataInput dataIn) throws IOException {
        return protocolFormat.looseUnmarshalNestedObject(dataIn);
    }

    protected void looseMarshalNestedObject(BESMPFormat protocolFormat, DataStructure o, DataOutput dataOut) throws IOException {
        protocolFormat.looseMarshalNestedObject(o, dataOut);
    }

    protected DataStructure looseUnmarsalCachedObject(BESMPFormat protocolFormat, DataInput dataIn) throws IOException {
        if (protocolFormat.isCacheEnabled()) {
            if (dataIn.readBoolean()) {
                short index = dataIn.readShort();
                DataStructure object = protocolFormat.looseUnmarshalNestedObject(dataIn);
                protocolFormat.setInUnmarshallCache(index, object);
                return object;
            }
            short index = dataIn.readShort();
            return protocolFormat.getFromUnmarshallCache(index);
        }
        return protocolFormat.looseUnmarshalNestedObject(dataIn);
    }

    protected void looseMarshalCachedObject(BESMPFormat protocolFormat, DataStructure o, DataOutput dataOut) throws IOException {
        if (protocolFormat.isCacheEnabled()) {
            Short index = protocolFormat.getMarshallCacheIndex(o);
            dataOut.writeBoolean(index == null);
            if (index == null) {
                index = protocolFormat.addToMarshallCache(o);
                dataOut.writeShort(index.shortValue());
                protocolFormat.looseMarshalNestedObject(o, dataOut);
            } else {
                dataOut.writeShort(index.shortValue());
            }
        } else {
            protocolFormat.looseMarshalNestedObject(o, dataOut);
        }
    }

    protected Throwable looseUnmarsalThrowable(BESMPFormat protocolFormat, DataInput dataIn) throws IOException {
        if (dataIn.readBoolean()) {
            String clazz = this.looseUnmarshalString(dataIn);
            String message = this.looseUnmarshalString(dataIn);
            Throwable o = this.createThrowable(clazz, message);
            if (protocolFormat.isStackTraceEnabled()) {
                if (STACK_TRACE_ELEMENT_CONSTRUCTOR != null) {
                    StackTraceElement[] ss = new StackTraceElement[dataIn.readShort()];
                    for (int i = 0; i < ss.length; ++i) {
                        try {
                            ss[i] = (StackTraceElement)STACK_TRACE_ELEMENT_CONSTRUCTOR.newInstance(this.looseUnmarshalString(dataIn), this.looseUnmarshalString(dataIn), this.looseUnmarshalString(dataIn), dataIn.readInt());
                            continue;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    o.setStackTrace(ss);
                } else {
                    int size = dataIn.readShort();
                    for (int i = 0; i < size; ++i) {
                        this.looseUnmarshalString(dataIn);
                        this.looseUnmarshalString(dataIn);
                        this.looseUnmarshalString(dataIn);
                        dataIn.readInt();
                    }
                }
                o.initCause(this.looseUnmarsalThrowable(protocolFormat, dataIn));
            }
            return o;
        }
        return null;
    }

    protected void looseMarshalThrowable(BESMPFormat protocolFormat, Throwable o, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(o != null);
        if (o != null) {
            this.looseMarshalString(o.getClass().getName(), dataOut);
            this.looseMarshalString(o.getMessage(), dataOut);
            if (protocolFormat.isStackTraceEnabled()) {
                StackTraceElement[] stackTrace = o.getStackTrace();
                dataOut.writeShort(stackTrace.length);
                for (int i = 0; i < stackTrace.length; ++i) {
                    StackTraceElement element = stackTrace[i];
                    this.looseMarshalString(element.getClassName(), dataOut);
                    this.looseMarshalString(element.getMethodName(), dataOut);
                    this.looseMarshalString(element.getFileName(), dataOut);
                    dataOut.writeInt(element.getLineNumber());
                }
                this.looseMarshalThrowable(protocolFormat, o.getCause(), dataOut);
            }
        }
    }

    protected String looseUnmarshalString(DataInput dataIn) throws IOException {
        if (dataIn.readBoolean()) {
            return dataIn.readUTF();
        }
        return null;
    }

    protected void looseMarshalString(String value, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(value != null);
        if (value != null) {
            dataOut.writeUTF(value);
        }
    }

    protected void looseMarshalObjectArray(BESMPFormat protocolFormat, DataStructure[] objects, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(objects != null);
        if (objects != null) {
            dataOut.writeShort(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                this.looseMarshalNestedObject(protocolFormat, objects[i], dataOut);
            }
        }
    }

    protected void looseMarshalConstByteArray(BESMPFormat protocolFormat, byte[] data, DataOutput dataOut, int i) throws IOException {
        dataOut.write(data, 0, i);
    }

    protected byte[] looseUnmarshalConstByteArray(DataInput dataIn, int i) throws IOException {
        byte[] data = new byte[i];
        dataIn.readFully(data);
        return data;
    }

    protected void looseMarshalByteArray(BESMPFormat protocolFormat, byte[] data, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(data != null);
        if (data != null) {
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }
    }

    protected byte[] looseUnmarshalByteArray(DataInput dataIn) throws IOException {
        byte[] rc = null;
        if (dataIn.readBoolean()) {
            int size = dataIn.readInt();
            rc = new byte[size];
            dataIn.readFully(rc);
        }
        return rc;
    }

    protected void looseMarshalByteSequence(BESMPFormat protocolFormat, ByteSequence data, DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(data != null);
        if (data != null) {
            dataOut.writeInt(data.getLength());
            dataOut.write(data.getData(), data.getOffset(), data.getLength());
        }
    }

    protected ByteSequence looseUnmarshalByteSequence(DataInput dataIn) throws IOException {
        ByteSequence rc = null;
        if (dataIn.readBoolean()) {
            int size = dataIn.readInt();
            byte[] t = new byte[size];
            dataIn.readFully(t);
            rc = new ByteSequence(t, 0, size);
        }
        return rc;
    }

    static {
        Constructor constructor = null;
        try {
            constructor = StackTraceElement.class.getConstructor(String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        STACK_TRACE_ELEMENT_CONSTRUCTOR = constructor;
    }
}

