/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.besmp.v1;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.besmp.BooleanStream;
import com.bes.mq.besmp.v1.BaseCommandMarshaller;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.DataStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BrokerInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 8;
    }

    public DataStructure createObject() {
        return new BrokerInfo();
    }

    public void tightUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(protocolFormat, o, dataIn, bs);
        BrokerInfo info = (BrokerInfo)o;
        info.setBrokerId((BrokerId)this.tightUnmarsalCachedObject(protocolFormat, dataIn, bs));
        info.setBrokerURL(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerInfo[] value = new BrokerInfo[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerInfo)this.tightUnmarsalNestedObject(protocolFormat, dataIn, bs);
            }
            info.setPeerBrokerInfos(value);
        } else {
            info.setPeerBrokerInfos(null);
        }
        info.setBrokerName(this.tightUnmarshalString(dataIn, bs));
        info.setSlaveBroker(bs.readBoolean());
        info.setMasterBroker(bs.readBoolean());
        info.setFaultTolerantConfiguration(bs.readBoolean());
        info.setDuplexConnection(bs.readBoolean());
        info.setNetworkConnection(bs.readBoolean());
        info.setConnectionId(this.tightUnmarshalLong(protocolFormat, dataIn, bs));
        info.setBrokerUploadUrl(this.tightUnmarshalString(dataIn, bs));
        info.setNetworkProperties(this.tightUnmarshalString(dataIn, bs));
    }

    public int tightMarshal1(BESMPFormat protocolFormat, Object o, BooleanStream bs) throws IOException {
        BrokerInfo info = (BrokerInfo)o;
        int rc = super.tightMarshal1(protocolFormat, o, bs);
        rc += this.tightMarshalCachedObject1(protocolFormat, info.getBrokerId(), bs);
        rc += this.tightMarshalString1(info.getBrokerURL(), bs);
        rc += this.tightMarshalObjectArray1(protocolFormat, info.getPeerBrokerInfos(), bs);
        rc += this.tightMarshalString1(info.getBrokerName(), bs);
        bs.writeBoolean(info.isSlaveBroker());
        bs.writeBoolean(info.isMasterBroker());
        bs.writeBoolean(info.isFaultTolerantConfiguration());
        bs.writeBoolean(info.isDuplexConnection());
        bs.writeBoolean(info.isNetworkConnection());
        rc += this.tightMarshalLong1(protocolFormat, info.getConnectionId(), bs);
        rc += this.tightMarshalString1(info.getBrokerUploadUrl(), bs);
        return (rc += this.tightMarshalString1(info.getNetworkProperties(), bs)) + 0;
    }

    public void tightMarshal2(BESMPFormat protocolFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(protocolFormat, o, dataOut, bs);
        BrokerInfo info = (BrokerInfo)o;
        this.tightMarshalCachedObject2(protocolFormat, info.getBrokerId(), dataOut, bs);
        this.tightMarshalString2(info.getBrokerURL(), dataOut, bs);
        this.tightMarshalObjectArray2(protocolFormat, info.getPeerBrokerInfos(), dataOut, bs);
        this.tightMarshalString2(info.getBrokerName(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalLong2(protocolFormat, info.getConnectionId(), dataOut, bs);
        this.tightMarshalString2(info.getBrokerUploadUrl(), dataOut, bs);
        this.tightMarshalString2(info.getNetworkProperties(), dataOut, bs);
    }

    public void looseUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(protocolFormat, o, dataIn);
        BrokerInfo info = (BrokerInfo)o;
        info.setBrokerId((BrokerId)this.looseUnmarsalCachedObject(protocolFormat, dataIn));
        info.setBrokerURL(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size = dataIn.readShort();
            BrokerInfo[] value = new BrokerInfo[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerInfo)this.looseUnmarsalNestedObject(protocolFormat, dataIn);
            }
            info.setPeerBrokerInfos(value);
        } else {
            info.setPeerBrokerInfos(null);
        }
        info.setBrokerName(this.looseUnmarshalString(dataIn));
        info.setSlaveBroker(dataIn.readBoolean());
        info.setMasterBroker(dataIn.readBoolean());
        info.setFaultTolerantConfiguration(dataIn.readBoolean());
        info.setDuplexConnection(dataIn.readBoolean());
        info.setNetworkConnection(dataIn.readBoolean());
        info.setConnectionId(this.looseUnmarshalLong(protocolFormat, dataIn));
        info.setBrokerUploadUrl(this.looseUnmarshalString(dataIn));
        info.setNetworkProperties(this.looseUnmarshalString(dataIn));
    }

    public void looseMarshal(BESMPFormat protocolFormat, Object o, DataOutput dataOut) throws IOException {
        BrokerInfo info = (BrokerInfo)o;
        super.looseMarshal(protocolFormat, o, dataOut);
        this.looseMarshalCachedObject(protocolFormat, info.getBrokerId(), dataOut);
        this.looseMarshalString(info.getBrokerURL(), dataOut);
        this.looseMarshalObjectArray(protocolFormat, info.getPeerBrokerInfos(), dataOut);
        this.looseMarshalString(info.getBrokerName(), dataOut);
        dataOut.writeBoolean(info.isSlaveBroker());
        dataOut.writeBoolean(info.isMasterBroker());
        dataOut.writeBoolean(info.isFaultTolerantConfiguration());
        dataOut.writeBoolean(info.isDuplexConnection());
        dataOut.writeBoolean(info.isNetworkConnection());
        this.looseMarshalLong(protocolFormat, info.getConnectionId(), dataOut);
        this.looseMarshalString(info.getBrokerUploadUrl(), dataOut);
        this.looseMarshalString(info.getNetworkProperties(), dataOut);
    }
}

