/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.besmp.v1;

import com.bes.mq.besmp.BESMPFormat;
import com.bes.mq.besmp.BooleanStream;
import com.bes.mq.besmp.v1.BaseCommandMarshaller;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.ConnectionId;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.DataStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConnectionInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 2;
    }

    public DataStructure createObject() {
        return new ConnectionInfo();
    }

    public void tightUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(protocolFormat, o, dataIn, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        info.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(protocolFormat, dataIn, bs));
        info.setClientId(this.tightUnmarshalString(dataIn, bs));
        info.setPassword(this.tightUnmarshalString(dataIn, bs));
        info.setUserName(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(protocolFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
        info.setBrokerMasterConnector(bs.readBoolean());
        info.setManageable(bs.readBoolean());
        info.setClientMaster(bs.readBoolean());
        info.setFaultTolerant(bs.readBoolean());
        info.setFailoverReconnect(bs.readBoolean());
        info.setClientIp(this.tightUnmarshalString(dataIn, bs));
    }

    public int tightMarshal1(BESMPFormat protocolFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionInfo info = (ConnectionInfo)o;
        int rc = super.tightMarshal1(protocolFormat, o, bs);
        rc += this.tightMarshalCachedObject1(protocolFormat, info.getConnectionId(), bs);
        rc += this.tightMarshalString1(info.getClientId(), bs);
        rc += this.tightMarshalString1(info.getPassword(), bs);
        rc += this.tightMarshalString1(info.getUserName(), bs);
        rc += this.tightMarshalObjectArray1(protocolFormat, info.getBrokerPath(), bs);
        bs.writeBoolean(info.isBrokerMasterConnector());
        bs.writeBoolean(info.isManageable());
        bs.writeBoolean(info.isClientMaster());
        bs.writeBoolean(info.isFaultTolerant());
        bs.writeBoolean(info.isFailoverReconnect());
        return (rc += this.tightMarshalString1(info.getClientIp(), bs)) + 0;
    }

    public void tightMarshal2(BESMPFormat protocolFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(protocolFormat, o, dataOut, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        this.tightMarshalCachedObject2(protocolFormat, info.getConnectionId(), dataOut, bs);
        this.tightMarshalString2(info.getClientId(), dataOut, bs);
        this.tightMarshalString2(info.getPassword(), dataOut, bs);
        this.tightMarshalString2(info.getUserName(), dataOut, bs);
        this.tightMarshalObjectArray2(protocolFormat, info.getBrokerPath(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalString2(info.getClientIp(), dataOut, bs);
    }

    public void looseUnmarshal(BESMPFormat protocolFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(protocolFormat, o, dataIn);
        ConnectionInfo info = (ConnectionInfo)o;
        info.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(protocolFormat, dataIn));
        info.setClientId(this.looseUnmarshalString(dataIn));
        info.setPassword(this.looseUnmarshalString(dataIn));
        info.setUserName(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(protocolFormat, dataIn);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
        info.setBrokerMasterConnector(dataIn.readBoolean());
        info.setManageable(dataIn.readBoolean());
        info.setClientMaster(dataIn.readBoolean());
        info.setFaultTolerant(dataIn.readBoolean());
        info.setFailoverReconnect(dataIn.readBoolean());
        info.setClientIp(this.looseUnmarshalString(dataIn));
    }

    public void looseMarshal(BESMPFormat protocolFormat, Object o, DataOutput dataOut) throws IOException {
        ConnectionInfo info = (ConnectionInfo)o;
        super.looseMarshal(protocolFormat, o, dataOut);
        this.looseMarshalCachedObject(protocolFormat, info.getConnectionId(), dataOut);
        this.looseMarshalString(info.getClientId(), dataOut);
        this.looseMarshalString(info.getPassword(), dataOut);
        this.looseMarshalString(info.getUserName(), dataOut);
        this.looseMarshalObjectArray(protocolFormat, info.getBrokerPath(), dataOut);
        dataOut.writeBoolean(info.isBrokerMasterConnector());
        dataOut.writeBoolean(info.isManageable());
        dataOut.writeBoolean(info.isClientMaster());
        dataOut.writeBoolean(info.isFaultTolerant());
        dataOut.writeBoolean(info.isFailoverReconnect());
        this.looseMarshalString(info.getClientIp(), dataOut);
    }
}

