/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.blob;

import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.blob.BlobUploadStrategy;
import com.bes.mq.command.BESMQBlobMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jms.JMSException;

public class BlobUploader {
    private final BlobTransferPolicy blobTransferPolicy;
    private File file;
    private InputStream in;

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, InputStream in) {
        this.blobTransferPolicy = blobTransferPolicy.copy();
        this.in = in;
    }

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, File file) {
        this.blobTransferPolicy = blobTransferPolicy.copy();
        this.file = file;
    }

    public URL upload(BESMQBlobMessage message) throws JMSException, IOException {
        if (this.file != null) {
            return this.getStrategy().uploadFile(message, this.file);
        }
        return this.getStrategy().uploadStream(message, this.in);
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public BlobUploadStrategy getStrategy() {
        return this.getBlobTransferPolicy().getUploadStrategy();
    }
}

