/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.blob;

import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.blob.BlobUploadStrategy;
import com.bes.mq.blob.DefaultStrategy;
import com.bes.mq.command.BESMQBlobMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.jms.JMSException;

public class DefaultBlobUploadStrategy
extends DefaultStrategy
implements BlobUploadStrategy {
    public DefaultBlobUploadStrategy(BlobTransferPolicy transferPolicy) {
        super(transferPolicy);
    }

    public URL uploadFile(BESMQBlobMessage message, File file) throws JMSException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL uploadStream(BESMQBlobMessage message, InputStream fis) throws JMSException, IOException {
        URL url = this.createMessageURL(message);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(this.transferPolicy.getBufferSize());
        OutputStream os = connection.getOutputStream();
        byte[] buf = new byte[this.transferPolicy.getBufferSize()];
        try {
            int c = fis.read(buf);
            while (c != -1) {
                os.write(buf, 0, c);
                os.flush();
                c = fis.read(buf);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                os.close();
            }
            finally {
                fis.close();
            }
        }
        if (!this.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("PUT was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return url;
    }
}

