/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.blob;

import com.bes.mq.blob.BlobDownloadStrategy;
import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.blob.FTPStrategy;
import com.bes.mq.command.BESMQBlobMessage;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.jms.JMSException;
import org.apache.commons.net.ftp.FTPClient;

public class FTPBlobDownloadStrategy
extends FTPStrategy
implements BlobDownloadStrategy {
    public FTPBlobDownloadStrategy(BlobTransferPolicy transferPolicy) throws MalformedURLException {
        super(transferPolicy);
    }

    public InputStream getInputStream(BESMQBlobMessage message) throws IOException, JMSException {
        this.url = message.getURL();
        final FTPClient ftp = this.createFTP();
        String path = this.url.getPath();
        String workingDir = path.substring(0, path.lastIndexOf("/"));
        String file = path.substring(path.lastIndexOf("/") + 1);
        ftp.changeWorkingDirectory(workingDir);
        ftp.setFileType(2);
        FilterInputStream input = new FilterInputStream(ftp.retrieveFileStream(file)){

            public void close() throws IOException {
                this.in.close();
                ftp.quit();
                ftp.disconnect();
            }
        };
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(BESMQBlobMessage message) throws IOException, JMSException {
        this.url = message.getURL();
        FTPClient ftp = this.createFTP();
        String path = this.url.getPath();
        try {
            if (!ftp.deleteFile(path)) {
                throw new JMSException("Delete file failed: " + ftp.getReplyString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ftp.quit();
            ftp.disconnect();
            throw throwable;
        }
        ftp.quit();
        ftp.disconnect();
    }
}

