/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.blob;

import com.bes.mq.blob.BlobDownloadStrategy;
import com.bes.mq.blob.BlobTransferPolicy;
import com.bes.mq.blob.BlobUploadStrategy;
import com.bes.mq.command.BESMQBlobMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.jms.JMSException;

public class FileSystemBlobStrategy
implements BlobUploadStrategy,
BlobDownloadStrategy {
    private final BlobTransferPolicy policy;
    private File rootFile;

    public FileSystemBlobStrategy(BlobTransferPolicy policy) throws MalformedURLException, URISyntaxException {
        this.policy = policy;
        this.createRootFolder();
    }

    protected void createRootFolder() throws MalformedURLException, URISyntaxException {
        this.rootFile = new File(new URL(this.policy.getUploadUrl()).toURI());
        if (!this.rootFile.exists()) {
            this.rootFile.mkdirs();
        } else if (!this.rootFile.isDirectory()) {
            throw new IllegalArgumentException("Given url is not a directory " + this.rootFile);
        }
    }

    public URL uploadFile(BESMQBlobMessage message, File file) throws JMSException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL uploadStream(BESMQBlobMessage message, InputStream in) throws JMSException, IOException {
        File f = this.getFile(message);
        FileOutputStream out = new FileOutputStream(f);
        byte[] buffer = new byte[this.policy.getBufferSize()];
        try {
            int c = in.read(buffer);
            while (c != -1) {
                out.write(buffer, 0, c);
                out.flush();
                c = in.read(buffer);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                out.flush();
            }
            finally {
                try {
                    out.close();
                }
                finally {
                    in.close();
                }
            }
        }
        return f.toURI().toURL();
    }

    public void deleteFile(BESMQBlobMessage message) throws IOException, JMSException {
        File f = this.getFile(message);
        if (f.exists() && !f.delete()) {
            throw new IOException("Unable to delete file " + f);
        }
    }

    public InputStream getInputStream(BESMQBlobMessage message) throws IOException, JMSException {
        return new FileInputStream(this.getFile(message));
    }

    protected File getFile(BESMQBlobMessage message) throws JMSException, IOException {
        if (message.getURL() != null) {
            try {
                return new File(message.getURL().toURI());
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException("Unable to open file for message " + message);
                ioe.initCause(e);
            }
        }
        String fileName = message.getJMSMessageID().replaceAll(":", "_");
        return new File(this.rootFile, fileName);
    }
}

