/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.Locker;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.util.ServiceSupport;
import java.io.IOException;

public abstract class AbstractLocker
extends ServiceSupport
implements Locker {
    private static long DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = 10000L;
    private static final long DEFAULT_LOCK_ACQUIRE_FAILED_PRINT_TIMES = 30L;
    private static final boolean PRINT_LOCK_ACQUIRE_RETRY_MESSAGE = System.getProperty("com.bes.mq.broker.printLockAcquireRetryMessage") != null ? Boolean.getBoolean("com.bes.mq.broker.printLockAcquireRetryMessage") : true;
    private static final String KEY_LOG_LOCK_ACQUIRE_RETRY_MESSAGE = "com.bes.mq.broker.printLockAcquireRetryMessage";
    private static final String KEY_LOCK_ACQUIRE_SLEEP_INTERVAL = "com.bes.mq.broker.lockAcquireSleepIntervalInMills";
    protected String name;
    protected boolean failIfLocked = false;
    protected long lockAcquireSleepInterval = Math.max(100L, DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL);
    protected long lockAcquireFailedTimes = 0L;

    public boolean keepAlive() throws IOException {
        return true;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFailIfLocked(boolean failIfLocked) {
        this.failIfLocked = failIfLocked;
    }

    protected void lockAcquireFailed(Exception cause) {
        if (this.getLogger() == null) {
            return;
        }
        ++this.lockAcquireFailedTimes;
        long lockAcquireSleepIntervalInSeconds = this.lockAcquireSleepInterval / 1000L;
        String message = "Failed to acquire lock " + this.lockAcquireFailedTimes + " times, waiting " + lockAcquireSleepIntervalInSeconds + " seconds to try again. Reason: " + cause.getMessage();
        if (this.lockAcquireFailedTimes == 1L) {
            this.getLogger().warn(message);
        } else {
            boolean isPrintMessage;
            boolean bl = isPrintMessage = PRINT_LOCK_ACQUIRE_RETRY_MESSAGE && this.lockAcquireFailedTimes % 30L == 0L;
            if (isPrintMessage) {
                this.getLogger().warn(message);
            }
        }
    }

    protected abstract Logger getLogger();

    static {
        String lockAcquireSleepInterval = System.getProperty(KEY_LOCK_ACQUIRE_SLEEP_INTERVAL);
        if (lockAcquireSleepInterval != null) {
            try {
                DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = Long.valueOf(lockAcquireSleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

