/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class AliasedX509KeyManager
extends X509ExtendedKeyManager {
    private String keyAlias;
    private X509KeyManager keyManager;

    public AliasedX509KeyManager(String keyAlias, X509KeyManager keyManager) {
        this.keyAlias = keyAlias;
        this.keyManager = keyManager;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.keyAlias == null ? this.keyManager.chooseClientAlias(keyType, issuers, socket) : this.keyAlias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.keyAlias == null ? this.keyManager.chooseServerAlias(keyType, issuers, socket) : this.keyAlias;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }
}

