/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.Service;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.broker.Connection;
import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.broker.region.Destination;
import com.bes.mq.broker.region.MessageReference;
import com.bes.mq.broker.region.Region;
import com.bes.mq.broker.region.Subscription;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.command.BrokerId;
import com.bes.mq.command.BrokerInfo;
import com.bes.mq.command.ConnectionInfo;
import com.bes.mq.command.DestinationInfo;
import com.bes.mq.command.MessageDispatch;
import com.bes.mq.command.ProducerInfo;
import com.bes.mq.command.SessionInfo;
import com.bes.mq.command.TransactionId;
import com.bes.mq.store.hsdb.plist.PListStore;
import com.bes.mq.thread.Scheduler;
import com.bes.mq.usage.Usage;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Broker
extends Region,
Service {
    public Broker getAdaptor(Class var1);

    public BrokerId getBrokerId();

    public String getBrokerName();

    public void addBroker(Connection var1, BrokerInfo var2);

    public void removeBroker(Connection var1, BrokerInfo var2);

    public void addConnection(ConnectionContext var1, ConnectionInfo var2) throws Exception;

    public void removeConnection(ConnectionContext var1, ConnectionInfo var2, Throwable var3) throws Exception;

    public void addSession(ConnectionContext var1, SessionInfo var2) throws Exception;

    public void removeSession(ConnectionContext var1, SessionInfo var2) throws Exception;

    @Override
    public void addProducer(ConnectionContext var1, ProducerInfo var2) throws Exception;

    @Override
    public void removeProducer(ConnectionContext var1, ProducerInfo var2) throws Exception;

    public Connection[] getClients() throws Exception;

    public BESMQDestination[] getDestinations() throws Exception;

    public TransactionId[] getPreparedTransactions(ConnectionContext var1) throws Exception;

    public void beginTransaction(ConnectionContext var1, TransactionId var2) throws Exception;

    public int prepareTransaction(ConnectionContext var1, TransactionId var2) throws Exception;

    public void rollbackTransaction(ConnectionContext var1, TransactionId var2) throws Exception;

    public void commitTransaction(ConnectionContext var1, TransactionId var2, boolean var3) throws Exception;

    public void forgetTransaction(ConnectionContext var1, TransactionId var2) throws Exception;

    public BrokerInfo[] getPeerBrokerInfos();

    public void preProcessDispatch(MessageDispatch var1);

    public void postProcessDispatch(MessageDispatch var1);

    public boolean isStopped();

    public Set<BESMQDestination> getDurableDestinations();

    public void addDestinationInfo(ConnectionContext var1, DestinationInfo var2) throws Exception;

    public void removeDestinationInfo(ConnectionContext var1, DestinationInfo var2) throws Exception;

    public boolean isFaultTolerantConfiguration();

    public ConnectionContext getAdminConnectionContext();

    public void setAdminConnectionContext(ConnectionContext var1);

    public PListStore getTempDataStore();

    public URI getVmConnectorURI();

    public void brokerServiceStarted();

    public BrokerService getBrokerService();

    public Broker getRoot();

    public boolean isExpired(MessageReference var1);

    public void messageExpired(ConnectionContext var1, MessageReference var2, Subscription var3);

    public boolean sendToDeadLetterQueue(ConnectionContext var1, MessageReference var2, Subscription var3, Throwable var4);

    public long getBrokerSequenceId();

    public void messageConsumed(ConnectionContext var1, MessageReference var2);

    public void messageDelivered(ConnectionContext var1, MessageReference var2);

    public void messageDiscarded(ConnectionContext var1, Subscription var2, MessageReference var3);

    public void slowConsumer(ConnectionContext var1, Destination var2, Subscription var3);

    public void fastProducer(ConnectionContext var1, ProducerInfo var2, BESMQDestination var3);

    public void isFull(ConnectionContext var1, Destination var2, Usage var3);

    public void nowMasterBroker();

    public Scheduler getScheduler();

    public ThreadPoolExecutor getExecutor();

    public void networkBridgeStarted(BrokerInfo var1, boolean var2, String var3);

    public void networkBridgeStopped(BrokerInfo var1);
}

