/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.broker;

import com.bes.mq.broker.BrokerFactoryHandler;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.util.FactoryFinder;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;
import java.net.URI;

public final class BrokerFactory {
    private static final FactoryFinder BROKER_FACTORY_HANDLER_FINDER = new FactoryFinder("META-INF/services/com/bes/mq/broker/");

    private BrokerFactory() {
    }

    public static BrokerFactoryHandler createBrokerFactoryHandler(String type) throws IOException {
        try {
            return (BrokerFactoryHandler)BROKER_FACTORY_HANDLER_FINDER.newInstance(type);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not load " + type + " factory:" + e, e);
        }
    }

    public static BrokerService createBroker(URI brokerURI) throws Exception {
        return BrokerFactory.createBroker(brokerURI, false);
    }

    public static BrokerService createBroker(URI brokerURI, boolean startBroker) throws Exception {
        if (brokerURI.getScheme() == null) {
            throw new IllegalArgumentException("Invalid broker URI, no scheme specified: " + brokerURI);
        }
        BrokerFactoryHandler handler = BrokerFactory.createBrokerFactoryHandler(brokerURI.getScheme());
        BrokerService broker = handler.createBroker(brokerURI);
        if (startBroker) {
            broker.start();
        }
        return broker;
    }

    public static BrokerService createBroker(String brokerURI) throws Exception {
        return BrokerFactory.createBroker(new URI(brokerURI));
    }

    public static BrokerService createBroker(String brokerURI, boolean startBroker) throws Exception {
        return BrokerFactory.createBroker(new URI(brokerURI), startBroker);
    }
}

